package gui.componentEditor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;


abstract class MouseController implements MouseListener, MouseMotionListener {
    private int x = 0;
    private int y = 0;

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        released(e.getX(), e.getY());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            clickControl(new Point(e.getX(), e.getY()));
        } else {
            clicked(new Point(e.getX(), e.getY()));
        }

    }

    public void mousePressed(MouseEvent e) {
        x = e.getX();
        y = e.getY();
        pressed(new Point(x, y));
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isShiftDown()) {
            dragShift(new Point(x, y), new Point(e.getX(), e.getY()));
        } else {
            dragged(new Point(x, y), new Point(e.getX(), e.getY()));
        }
    }

    public abstract void released(int x, int y);

    public abstract void dragged(Point p1, Point p2);

    public abstract void dragShift(Point p1, Point p2);

    public abstract void pressed(Point p);

    public abstract void clicked(Point p);

    public abstract void clickControl(Point p);


}


class MouseComponentMover extends MouseController {

    Component c;

    MouseComponentMover(Component _c) {
        c = _c;

        c.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        c.addMouseMotionListener(this);
        c.addMouseListener(this);
    }

    public void dragShift(Point p1, Point p2) {
        SwingUtilities.convertPointToScreen(p2, c);
        c.setSize(p2.x - c.getBounds().x, p2.y - c.getBounds().y);
        c.setCursor(Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR));
    }

    public void dragged(Point p1, Point p2) {
        c.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        Point p3 = c.getLocation();
        c.setLocation(p2.x + p3.x - p1.x, p2.y + p3.y - p1.y);
    }

    public void clicked(Point p) {
    }

    public void clickControl(Point p) {
        EditProperties e = new EditProperties(c);
    }

    public void shiftClicked(Point p) {
    }

    public void pressed(Point p) {
    }

    public void doubleClicked(Point p) {
    }

    public void released(int x, int y) {
        c.setCursor(
                Cursor.getPredefinedCursor(
                        Cursor.HAND_CURSOR)
        );
    }


}