/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package graphics.grapher;

import j2d.color.IndexImageBean;
import sound.recorder.SpectrogramFrame;

import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * Date: Jul 26, 2005
 * Time: 10:13:13 AM
 */
// graph.Main.notSoSimpleTest();
public class Main {

    public static void main(String[] args) {
        //simpleTest();
        notSoSimpleTest();

    }

    public static void simpleTest() {
        Graph.graph(getSampleY1Data(),"x","y^2");
        Graph.graph(getSampleY2Data(), "x", "y^2");
    }

    public static void notSoSimpleTest() {

        double yData[] = getSampleY1Data();
        double xData[] = new double[yData.length];
        for (int i = 0; i < yData.length; i++)
            xData[i] = i;

        int length = xData.length;

        if (length < 2) return;
        DoubleXYData doubleXYData = new DoubleXYData(length, "second", "kHz");

        doubleXYData.setX(xData);
        doubleXYData.setY(yData);

        GraphFrame gf = new GraphFrame(doubleXYData);
        gf.setImageData(getImage());
        gf.draw();
    }

    private static Image getImage() {
        IndexImageBean iib = SpectrogramFrame.getIndexImageBean();
        return iib.getImage();
    }

    public static double[] getSampleY1Data() {
        double d1[] = new double[100];

        for (int i=0; i < d1.length; i++){
            d1[i] = Math.sin(2.0*Math.PI*i/d1.length);
        }
        return d1;
    }
    public static double[] getSampleY2Data() {
        double d1[] = new double[100];

        for (int i = 0; i < d1.length; i++) {
            d1[i] = Math.cos(2.0 * Math.PI * i / d1.length);
        }
        return d1;
    }
}
