package graphics.grapher;

import gui.ClosableJFrame;

import java.awt.*;

/**
 * This class contains the graphcomponent, which has the
 * axix, lbels and images of data to be graphed.
 */
public class GraphFrame extends ClosableJFrame {

    private GraphComponent graphComponent = new GraphComponent();

    private Axis xaxis;
    private Axis yaxis;
    private int np;
    private ClosableJFrame cf = new ClosableJFrame("Graph Frame");
    private DataSet dataSet;
    private double data[];

    public GraphFrame(DoubleXYData doubleXYData) {
        super("Graph Frame");
        np = doubleXYData.getNp();
        doubleXYData.checkConsistent();
        //dl.print();
        initialize();

        data = new double[np * 2];
        makeAxis(doubleXYData);
    }

    void makeAxis(DoubleXYData doubleXYData) {
        int ix = 0;
        int iy = 1;
        for (int i = 0; i < np; i++) {
            data[ix] = doubleXYData.getX()[i];
            data[iy] = doubleXYData.getY()[i];
            ix = ix + 2;
            iy = iy + 2;
        }
        graphComponent.setBackground(Color.white);
        dataSet = graphComponent.loadDataSet(data, np);
        dataSet.linecolor = new Color(0, 0, 0);
        dataSet.legendColor(new Color(0, 0, 0));

        //xaxis = graphComponent.createAxis(Axis.TOP);
        //xaxis.attachDataSet(dataSet);
        // xaxis.title = dl.x_label;

        xaxis = graphComponent.createAxis(Axis.BOTTOM);
        xaxis.attachDataSet(dataSet);
        xaxis.title = doubleXYData.getXLabel();

        yaxis = graphComponent.createAxis(Axis.RIGHT);
        yaxis.attachDataSet(dataSet);
        yaxis.title = doubleXYData.getYLabel();

    }
    public void setImageData(Image img){
        graphComponent.setImageData(img);
    }
    private void initialize() {
        cf.addComponent("Center", graphComponent);
        cf.setSize(250, 250);
        cf.show();
    }

    public void draw() {
        cf.repaint();
    }

}