package graphics.grapher;

import java.awt.*;

/**
 * **********************************************************************
 * <p/>
 * ***********************************************************************
 */


class G2Dint extends GraphComponent {

/*
**    Set to true when a rectangle is being dragged out by the mouse
*/
    protected boolean drag = false;
/*
**    User limits. The user has set the limits using the mouse drag option
*/
    protected boolean userlimits = false;

/*
**    Ths popup window for the cursor position command
*/
    private Gin cpgin = null;
/*
**    Ths popup window for the data point command
*/
    private Gin dpgin = null;
/*
**    The popup window to manually set the range
*/
    private Range range = null;
/*
**    Button Down position
*/
    private int x0, y0;
/*
**    Button Drag position
*/
    private int x1, y1;
/*
**    Previous Button Drag position
*/
    private int x1old, y1old;

/*
**    Attached Axis which must be registered with this class
**    These are the axis used to find the drag range.
**    If no axis are registered no mouse drag.
*/
    protected Axis xaxis;
    protected Axis yaxis;


/*
**    Create xaxis to be used for the drag scaling
*/
    public Axis createXAxis() {
        xaxis = super.createAxis(Axis.BOTTOM);
        return xaxis;
    }
/*
**    Create yaxis to be used for the drag scaling
*/
    public Axis createYAxis() {
        yaxis = super.createAxis(Axis.LEFT);
        return yaxis;
    }
/*
**    Attach axis to be used for the drag scaling
*/
    public void attachAxis(Axis a) {
        if (a == null) return;

        super.attachAxis(a);

        if (a.getAxisPos() == Axis.BOTTOM || a.getAxisPos() == Axis.TOP) {
            xaxis = a;
        } else {
            yaxis = a;
        }
    }
/*
**  Override the normal Graph2D update method with this new one
*/
    public void update(Graphics g) {
        Rectangle r = getBounds();
        Color c = g.getColor();

        if (drag) {
/*
**         Drag out the new box.
**         Use drawLine instead of drawRect to avoid problems
**         when width and heights become negative. Seems drawRect
**         can't handle it!
*/

            g.setColor(getBackground());
            g.drawLine(x0, y0, x1old, y0);
            g.drawLine(x1old, y0, x1old, y1old);
            g.drawLine(x1old, y1old, x0, y1old);
            g.drawLine(x0, y1old, x0, y0);
            g.setColor(getForeground());
            g.drawLine(x0, y0, x1, y0);
            g.drawLine(x1, y0, x1, y1);
            g.drawLine(x1, y1, x0, y1);
            g.drawLine(x0, y1, x0, y0);


            g.setColor(c);

            x1old = x1;
            y1old = y1;

            return;
        }

        if (isClearAll()) {
            g.setColor(getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
        }
        if (isPaintAll()) paint(g);
    }



/*
**   Find the closest data point to the cursor
*/
    protected double[] getClosestPoint(int ix, int iy) {
        DataSet ds;
        int i;
        double a[] = new double[3];
        double distsq = -1.0;
        double data[] = {0.0, 0.0};
        double x = xaxis.getDouble(ix);
        double y = yaxis.getDouble(iy);

        //System.out.println("getClosestPoint: x="+x+", y="+y);

        for (i = 0; i < getDataset().size(); i++) {
            ds = (DataSet) (getDataset().elementAt(i));

            a = ds.getClosestPoint(x, y);

            if (distsq < 0.0 || distsq > a[2]) {
                data[0] = a[0];
                data[1] = a[1];
                distsq = a[2];
            }
        }
        return data;

    }

}

/*
** Gin
**      Popup a window to output data after a Graphics Input command
*/

class Gin extends Frame {

    private Label xlabel = new Label();
    private Label ylabel = new Label();


    public Gin() {

        setLayout(new GridLayout(2, 1));

        xlabel.setAlignment(Label.LEFT);
        ylabel.setAlignment(Label.LEFT);

        this.setFont(new Font("Helvetica", Font.PLAIN, 20));

        add("x", xlabel);
        add("y", ylabel);

        setSize(150, 100);
        super.setTitle("Graphics Input");
    }

    public Gin(String title) {
        this();
        if (title != null) super.setTitle(title);
    }

    public void setXlabel(double d) {
        xlabel.setText(String.valueOf(d));
    }

    public void setYlabel(double d) {
        ylabel.setText(String.valueOf(d));
    }

    public void setLabels(double dx, double dy) {
        xlabel.setText(String.valueOf(dx));
        ylabel.setText(String.valueOf(dy));
    }

    public void setFont(Font f) {

        if (f == null) return;
        xlabel.setFont(f);
        ylabel.setFont(f);

    }


}

/*
** Range
**      Popup a window for the range of the plot
*/

class Range extends Frame {

    GraphComponent g2d = null;


    private Label xminLabel = new Label("Xmin");
    private Label yminLabel = new Label("Ymin");
    private Label xmaxLabel = new Label("Xmax");
    private Label ymaxLabel = new Label("Ymax");

    private TextField xminText = new TextField(20);
    private TextField yminText = new TextField(20);
    private TextField xmaxText = new TextField(20);
    private TextField ymaxText = new TextField(20);

    private Button cancel = new Button("Cancel");
    private Button done = new Button("Done");


    public Range(GraphComponent g) {

        g2d = g;

        setLayout(new GridLayout(5, 2, 5, 10));

        xminLabel.setAlignment(Label.LEFT);
        xmaxLabel.setAlignment(Label.LEFT);
        yminLabel.setAlignment(Label.LEFT);
        ymaxLabel.setAlignment(Label.LEFT);


        add("xminLabel", xminLabel);
        add("xminText", xminText);

        add("xmaxLabel", xmaxLabel);
        add("xmaxText", xmaxText);

        add("yminLabel", yminLabel);
        add("yminText", yminText);

        add("ymaxLabel", ymaxLabel);
        add("ymaxText", ymaxText);

        add("cancel", cancel);
        cancel.setBackground(Color.red);

        add("done", done);
        done.setBackground(Color.green);

        setSize(250, 250);
        super.setTitle("Set Plot Range");
    }

    public Double getXmin() {
        try {
            return Double.valueOf(xminText.getText());
        } catch (Exception ex) {
            return null;
        }
    }

    public Double getXmax() {
        try {
            return Double.valueOf(xmaxText.getText());
        } catch (Exception ex) {
            return null;
        }
    }

    public Double getYmin() {
        try {
            return Double.valueOf(yminText.getText());
        } catch (Exception ex) {
            return null;
        }
    }

    public Double getYmax() {
        try {
            return Double.valueOf(ymaxText.getText());
        } catch (Exception ex) {
            return null;
        }
    }


    public void requestFocus() {
        xminText.requestFocus();
    }

}
