package futils.filters;

import gui.DateUtils;
import gui.dialogs.LabeledItemPanel;
import gui.dialogs.ModalDialog;
import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunTextField;

import javax.swing.*;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 8, 2005
 * <p/>
 * Time: 10:19:49 AM
 */
public class DateFilterDialog
        extends ModalDialog {
    DateFilterBean dfb =
            DateFilterBean.restore();
    GregorianCalendar calendar = new GregorianCalendar();

    public DateFilterDialog() {
        setTitle("DateFilterDialog");
        setModal(true);
        LabeledItemPanel c = new LabeledItemPanel();
        c.addItem("isFile", new RunCheckBox("", dfb.isFile()) {
            public void run() {
                dfb.setFile(isSelected());
            }
        });
        c.addItem("isDirectory", new RunCheckBox("", dfb.isDirectory()) {
            public void run() {
                dfb.setDirectory(isSelected());
            }
        });
        c.addItem("suffix", new RunTextField("") {
            public void run() {
                dfb.setSuffix(getText());
            }
        });
        c.addItem("look for files modified after date",
                new RunCheckBox("", dfb.isDated()) {
                    public void run() {
                        dfb.setDated(isSelected());
                    }
                });

        final RunTextField dateTextField = getDateTextField();
        c.addItem(DateUtils.SIMPLE_DATE_PATTERN,
                dateTextField);
        c.addItem("set to yesterdays' date", new RunButton("yesterday") {
            public void run() {
                final Date date = new Date();
                date.setTime(date.getTime() - 24 * 60 * 60 * 1000);
                dfb.setDate(date);
                dateTextField.setText(getSimpleDateString());
            }
        });

        c.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jsp = new JScrollPane(c);
        setContentPane(jsp);
    }

    private RunTextField getDateTextField() {
        return new RunTextField(getSimpleDateString(), 8) {
            public void run() {
                dfb.setDate(DateUtils.getSimpleDate(getText()));
            }
        };
    }

    private String getSimpleDateString() {
        return DateUtils.SIMPLE_DATE_FORMAT.format(dfb.getDate());
    }

    public static void main(String[] args) {
        DateFilterDialog dfd = new DateFilterDialog();
        dfd.pack();
        dfd.setVisible(true);
        final DateFilterBean dateFilterBean = dfd.getDateFilterBean();
        System.out.println(dateFilterBean);
        dateFilterBean.save();

    }

    public DateFilterBean getDateFilterBean() {
        return dfb;
    }
}
