package futils;

import java.io.*;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerialUtils {
    // futils.SerializeTest
    public static void testReadGzipObject() {
        try {
            System.out.println(readGzippedObject());
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Object readGzippedObject()
            throws
            IOException,
            FileNotFoundException,
            ClassNotFoundException {
        ObjectInputStream ois
                = new ObjectInputStream(new GZIPInputStream(new FileInputStream(Futil.getReadFile("select an object"))));
        return ois.readObject();

    }

    public static Object readObjectUncompressed()
            throws
            IOException,
            FileNotFoundException,
            ClassNotFoundException {
        FileInputStream fis
                = new FileInputStream(Futil.getReadFile("select an object"));
        ObjectInputStream ois
                = new ObjectInputStream(fis);
        Object o = ois.readObject();
        fis.close();
        return o;
    }

    public static void saveGzipObject(Object o)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(Futil.getWriteFile("select an output file for the object"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        ObjectOutputStream oos
                = new ObjectOutputStream(gos);
        oos.writeObject(o);
        oos.close();
        gos.finish();
    }

    public static void saveReadGzipObjectTest() {
        try {
            SerialUtils.saveGzipObject("this is a gzipped record");
        } catch (IOException e) {
            e.printStackTrace();
        }
        testReadGzipObject();
    }

    public static void testSaveGzipString() {
        try {
            writeGzipString("this is a test of myn"
                    + "gzipper string thing!");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        testReadWriteGzipString();
    }

    public static void testReadWriteGzipString() {
        try {
            writeGzipString("this is a test of a string in gzip");
            System.out.println(readGzipString());
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public static String readGzipString()
            throws IOException {
        File readFile = Futil.getReadFile(
                "select an input file for the string");
        FileInputStream fis
                = new FileInputStream(readFile);
        GZIPInputStream gis
                = new GZIPInputStream(fis);
        System.out.println("gis.available="+gis.available());
        StringBuffer sb = new StringBuffer();
        byte b[] = new byte[1];
        while (gis.read(b)!= -1){
           sb.append( new String(b));
        };
        fis.close();
        return sb.toString();
    }

    public static void writeGzipString(String s)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(Futil.getWriteFile("select an output file for the object"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        byte b[] = s.getBytes();
        gos.write(b);
        gos.finish();
        gos.close();
        fos.close();
    }

    public static void saveObjectUncompressed(Object o)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(Futil.getWriteFile("select an output file for the object"));
        ObjectOutputStream oos
                = new ObjectOutputStream(fos);
        oos.writeObject(o);
        oos.close();
    }

    public static void print(Customer c[]) {
        for (int i = 0; i < c.length; i++)
            c[i].print();
    }

    public static void testTheTest() {
        try {
            regressionTest();
            writeGzipString("this is a test of a compressed string");
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();

        }
    }

    private static void regressionTest()
            throws IOException, ClassNotFoundException {
        testUncompressedSave();
        testCompressedSave();
    }

    private static void testUncompressedSave()
            throws IOException, ClassNotFoundException {
        Customer c1[] = new Customer[100];
        for (int i = 0; i < 100; i++) {
            c1[i] = new Customer();
            c1[i].setName("cust#" + i);
        }

        System.out.println("Object out=");
        SerialUtils.saveObjectUncompressed(c1);
        System.out.println("Object in=");
        Object o =
                SerialUtils.readObjectUncompressed();
        if (o instanceof Customer[]) {
            Customer c[] =
                    (Customer[]) o;
            print(c);
        }
    }

    private static void testCompressedSave()
            throws IOException, ClassNotFoundException {
        Customer c1[] = new Customer[100];
        for (int i = 0; i < 100; i++) {
            c1[i] = new Customer();
            c1[i].setName("cust#" + i);
        }

        System.out.println("Object out=");
        saveGzipObject(c1);
        System.out.println("Object in=");
        Object o =
                readGzippedObject();
        if (o instanceof Customer[]) {
            Customer c[] =
                    (Customer[]) o;
            print(c);
        }
    }
}