/*
 * PartyProcessor.java
 * Created on December 4, 2002
 */

package collections.arrayList;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/**
 * A Dinner Party Processor which shows how to use an ArrayList
 * @author  Thomas Rowland
 */
public class PartyProcessor {

    private List parties = new ArrayList();

    public static void main(String[] args) {
        PartyProcessor proc = new PartyProcessor();

        //add some objects
        proc.addParty(new Party("Thomas", 4));
        proc.addParty(new Party("Jason", 3));
        proc.addParty(new Party("Tiffany", 5));
        proc.addParty(new Party("Terry", 3));
        proc.addParty(new Party("Brandy", 2));

        //display the objects
        proc.showParties();

        //update an object
        proc.updateParty(new Party("Jason", 8));
        proc.showParties();

        //locate objects with specific criteria
        proc.showNextPartyOf(3);
        proc.showPartyInQueue("Jason");

        //remove an object
        proc.removeParty("Thomas");
        proc.showParties();
    }

    // adds an element to the end of the list
    public void addParty(Party party) {
        parties.add(party);
        System.out.println("Added: " + party);
    }

    // replaces an element with the one specified
    public boolean updateParty(Party party) {
        int index = parties.indexOf(party);
        if (index == -1) return false;
        parties.set(index, party);
        System.out.println("Updated party " + party + ", at index " + (index));
        return true;
    }

    // removes an element from the list
    public void removeParty(String name) {
        Party party = new Party(name);
        int index = parties.indexOf(party);
        if (index == -1) System.out.println("party not found.");
        System.out.println("\nRemoved party " + parties.remove(index)
                + " at index " + index);
    }

    // gets an element in the list with specified criteria
    public void showNextPartyOf(int partySize) {
        ListIterator iter = parties.listIterator();
        while (iter.hasNext()) {
            Party party = (Party) iter.next();
            if (party.getPartySize() == partySize) {
                System.out.println("\nNext party of " + partySize + ": " + party);
                return;
            }
        }
    }

    // gets an element in the list with specified criteria
    public void showPartyInQueue(String partyName) {
        System.out.println("\nParty: " + partyName + " No. in queue: "
                + (parties.indexOf(new Party(partyName)) + 1));
    }

    public void showParties() {
        ListIterator iter = parties.listIterator();
        System.out.println("\nCurrently " + parties.size() + " parties...");
        Party p;
        while (iter.hasNext()) {
            Party party = (Party) iter.next();
            System.out.println(party);
        }
    }
}
