package classUtils.resolver.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * @author Douglas Tillman, VTE Consulting, 12/2002
 * @version 2.0 http://home.attbi.com/~doug.tillman/index.html
 *          <p/>
 *          Represents individual jar file's attributes and exploded
 *          contents.
 */
public class AuditableJarFile extends JarFile {

    private File f;
    private ArrayList explodedContents;


    /**
     * Constructor method that takes two parameters to satisfy call to
     * superclass' constructor.
     *
     * @param root - root directory of current file under examination.
     */
    public AuditableJarFile(File root) throws IOException {

        super(root);
        f = root;
        explodedContents = new ArrayList();
        setExplodedContents();
    }

    /**
     * Standard getter method to return the ArrayList of class file names.
     */
    public ArrayList getExplodedContents() {
        return explodedContents;
    }

    /**
     * Sets the contents, class files only, as an instance variable in the
     * JarFile object.
     */
    public void setExplodedContents() {

        Enumeration jarClassNames = this.entries();
        String qualClassName = null;

        while (jarClassNames.hasMoreElements()) {

            try {
                qualClassName =
                        ((JarEntry) jarClassNames.nextElement()).getName();
                int posLastSlash = qualClassName.lastIndexOf('/');

                if (posLastSlash > 0) {
                    if ((qualClassName.substring(posLastSlash,
                            qualClassName.length())).endsWith("class"))
                        explodedContents.add(qualClassName);
                }
            } catch (StringIndexOutOfBoundsException oobe) {
                System.out.println(
                        "unauditable class name: " + qualClassName);
            }

        }
    }

    /**
     * Returns underlying File object
     *
     * @return java.io.File used to construct the instance
     */
    public File getFile() {
        return f;
    }

}
