//Ryan Metz


package classUtils.reflection;

import gui.run.RunButton;
import gui.run.RunList;

import javax.swing.*;
import java.awt.*;

public class GuiForCompObj {
    private static Class classToBeComputed[];

    public static void main(String args[]) {
        FindCompObj.getCompObjList();
        JFrame j = new JFrame();
        j.setSize(500, 150);
        j.getContentPane().setLayout(new BorderLayout());
        j.getContentPane().add(getButtonPane(), BorderLayout.CENTER);
        j.getContentPane().add(getClassListPane(), BorderLayout.NORTH);
        j.setVisible(true);
    }

    private static JPanel getClassListPane() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunList(FindCompObj.getClassVector()) {
            public void run() {
                Object o[] = getSelectedValues();
                classToBeComputed = new Class[o.length];
                for (int i = 0; i < o.length; i++) {
                    classToBeComputed[i] = (Class) o[i];
                }
            }

        });
        return jp;
    }

    private static JPanel getButtonPane() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("Compute") {
            public void run() {
                for (int i = 0; i < classToBeComputed.length; i++) {
                    System.out.println(classToBeComputed[i].getName());
                    classUtils.reflection.CompObjClient coc = new classUtils.reflection.CompObjClient();
                    coc.setCo(classToBeComputed[i]);
                    coc.run();
                }
            }
        });
        return jp;
    }
}
