/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package classUtils.putils;

import java.util.StringTokenizer;

public class LibraryPathUtils {
    public static void main(String[] args) {
        printLibraryPaths();
    }

    public static void printLibraryPaths() {
        System.out.println("The getLibraryPath=");
        String s[] = getLibraryPaths();
        print(s);
    }


    public static void print(Object o) {
        System.out.println(o);
    }


    public static void print(Object s[]) {
        if (s == null) return;
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i]);
        System.out.println("found:" + s.length + " items");
    }


    public static void print(Class s[]) {
        if (s == null) return;
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i].getName());
        System.out.println("found:" + s.length + " Classes");
    }


    public static String[] getLibraryPaths() {
        return parsePath(System.getProperty("java.library.path"));
    }

    /**
     * Input a path separator delimited set of directories and return one
     * per string element in an array.
     */
    private static String[] parsePath(String classPath) {
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer st =
                new StringTokenizer(
                        classPath,
                        pathSeparator);
        int n = st.countTokens();
        String s[] = new String[n];
        for (int i = 0; i < n; i++)
            s[i] = st.nextToken();
        return s;
    }

}
