package classUtils.putils;

import classUtils.dumper.ClassFile;
import classUtils.javassist.CannotCompileException;
import classUtils.javassist.ClassPool;
import classUtils.javassist.CompileTimeClass;
import classUtils.javassist.NotFoundException;
import classUtils.javassist.bytecode.JAClassFile;
import classUtils.loaders.ByteCodeContainer;
import classUtils.loaders.Reloader;
import classUtils.pathUtils.PathTabbedPane;
import classUtils.reflection.MethodList;
import futils.DirList;
import futils.Futil;
import futils.Ls;
import gui.In;
import utils.StringUtils;
import utils.SystemUtils;

import java.io.*;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;

public class ClassPathUtils {
    private static ClassPool cp = ClassPool.getDefault();
    private static ClassListBean classListBean = ClassListBean.restore();
    private static String key = "classPath";


    private static void testGetClass() throws NotFoundException,
                                              IOException,
                                              CannotCompileException {
        getClass(Futil.getReadFile("select a class file"));
    }

    public static void testGetPathsComposite() {
        testGetClassPathInUserDir();
        System.out.println("The classpath=" + getClassPath());
        System.out.println("the above is in the users directory...");
        testGetPaths();
    }

    private static void testGetPaths() {
        String s[] = ClassPathUtils.getClassPaths();
        print(s);
    }

    private static void testGetClassPathInUserDir() {
        String s = getClassPathInUserDir();
        System.out.println(s);
    }

    /**
     * Search the class path and return the first one that appears in the
     * users directory
     *
     * @return string representing a path in the users directory
     */
    public static String getClassPathInUserDir() {
        String s[] = getClassPaths();
        String usrDir = SystemUtils.getUserDir();
        for (int i = 0; i < s.length; i++)
            if (s[i].indexOf(usrDir) >= 0) {
                String suspectedPath = s[i] +
                        SystemUtils.getDirectorySeparator();
                File f = new File(suspectedPath);
                if (f.isDirectory()) return suspectedPath;
            }
        return Futil.getReadDirFileJTree(
                "select a user class path directory")
                .getAbsolutePath();
    }

    public static void testGetClassPath() {
        String s = getClassPath();
        System.out.println(s);
    }

    public static void testJarList() {
        JarFile jf = getAJarFile();
        printEntries(jf);
        //loadJarEntry(jf);
        //System.out.println("---- Jar entries are ---");
        // print(jf);
        //System.out.println("---- Class Entries are ---");
        //Class ca[] = getClasses(jf);
        //print(ca);
    }

    public static Class[] getClasses(JarFile jf) {
        loadJar(jf);
        return classListBean.getClasses();
    }

    public static void testGetComputableClasses() {
        print("The class files are:");
        File cf[] = Reloader.getClassFiles();
        loadClasses(cf);
        Class c[] = getClasses();
        print(getComputableClasses(c));

        //ClassList.sort(ca);

        //PackageTree pt = new PackageTree(buildTree(ca));
        //pt.setBounds(0, 0, 380, 280);
        //pt.setVisible(true);
    }

    public static File[] getClassFiles() {
        DirList dl = new DirList(".class");
        return dl.getFiles();
    }

    public static void printInterfaces(Class c[]) {
        for (int i = 0; i < c.length; i++)
            printComputableObjects(c[i]);
    }

    public static Class[] getComputableClasses(Class c[]) {
        Vector v = new Vector();
        for (int i = 0; i < c.length; i++)
            if (implementsComputableObject(c[i]))
                v.addElement(c[i]);
        Class ca[] = new Class[v.size()];
        v.copyInto(ca);
        return ca;
    }

    public static void printComputableObjects(Class c) {
        if (implementsComputableObject(c)) {
            System.out.println("ComputableObjectFound!:" +
                    c.getName());
        }
    }

    public static void printClassArray(Class[] classArray) {
        print("The class array is");
        print(classArray);
    }

    public static void printJars() {
        JarFile jfs[] = getJarFiles();
        print(jfs);
        //loadJars(jfs);
    }

    /**
     * This works and lets the user select class files and get their
     * names.
     */
    public static void testClassFileToClassName() {
        do {
            try {
                File f = Futil.getReadFile("select a class file");
                In.message("class name =" + getClassName(f));
            } catch (IOException e) {
                In.message(e);

            }
        } while (In.getBoolean("go again?"));
    }

    /**
     * Input a class file and return the class name that corresponds to
     * it. This does not add the class to the path.
     *
     * @param ccf
     * @return
     * @throws IOException
     */
    public static String getClassName(File ccf)
            throws IOException {
        final FileInputStream fis = new FileInputStream(ccf);
        DataInputStream dis = new DataInputStream(fis);
        JAClassFile cf = new JAClassFile(dis);

        String name = cf.getName();
        fis.close();
        return name;
    }

    public static ClassPool getClassPool() {
        return cp;
    }

    /**
     * This will allow the user to adjust the class path until a class
     * loads.
     */
    public static Class getClass(File f1) throws NotFoundException,
                                                 IOException,
                                                 CannotCompileException {
        return getClass(f1, cp);
    }

    private static Class getClass(File f1, ClassPool cp)
            throws IOException, NotFoundException, CannotCompileException {
        String cn = getClassName(f1);
        CompileTimeClass cc = cp.get(cn);
        Class c = cc.toClass();
        return c;
    }

    /**
     * Insert the directory into the head of the <code>java.class.path</code>
     *
     * @param dir
     */
    public static void addClassPath(String dir) {
        Properties p = System.getProperties();
        String oldPath = System.getProperty("java.class.path");
        String newPath = dir +
                System.getProperty("path.separator") +
                oldPath;
        p.put("java.class.path", newPath);
        System.setProperties(p);
    }

    /**
     * Insert the file into the head of the <code>java.class.path</code>
     *
     * @param f each of the files in the area will be inserted
     */
    public static void addClassPath(File f[]) {
        for (int i = 0; i < f.length; i++)
            addClassPath(f[i].toString());
    }

    public static boolean contains(String s1,
                                   String s2) {
        if (-1 == s1.indexOf(s2)) return false;
        return true;
    }

    public static Vector buildTree(Class ca[]) {
        Vector root = new Vector();
        Package p[] = getPackages();
        Vector pv = new Vector();
        pv.add("packages");
        Vector cv = new Vector();
        for (int i = 0; i < p.length; i++) {
            Package pp = p[i];
            String packageName = pp.getName();
            pv.add(packageName);
        }
        root.add(pv);
        for (int j = 0; j < ca.length; j++) {
            if ((j % 10) == 0) {
                root.add(cv);
                cv = new Vector();
            }
            String className = ca[j].getName();
            // System.out.println(className);
            if (contains(className,
                    "cutils.putils"))
                ;
            cv.add(className);
        }
        root.add(cv);
        return root;
    }

    public static void print(Object o) {
        System.out.println(o);
    }

    public static void printSystemInfo() {
        System.out.println("loadPackages:");
        loadPackages();
        System.out.println("loaded packages");
        print(getPackages());
        System.out.println("loaded "
                +
                classListBean.getSize()
                + " classes");
        System.out.println("number of methods=" +
                classListBean.getNumberOfMethods());
        print(classListBean.getClasses());
    }


    /**
     * list all the classes loaded into the system.
     */
    public static Class[] getClasses() {
        return classListBean.getClasses();
    }

    public static void printClassPaths() {
        String s[] = getClassPaths();
        print(s);
    }

    public static void printJars(String jfn[]) {
        for (int i = 0; i < jfn.length; i++)
            printJars(jfn[i]);
    }

    public static void printJars(String jfn) {
        try {
            JarFile jf = new JarFile(jfn);
            System.out.println("jarName=" + jf.getName());
            print(jf);
        } catch (java.io.IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadJars(JarFile jf[]) {
        if (jf == null) return;
        for (int i = 0; i < jf.length; i++)
            loadJar(jf[i]);
    }

    public static void loadClasses(File cf[]) {
        if (cf == null) return;
        for (int i = 0; i < cf.length; i++)
            loadClass(cf[i].toString());
    }

    public static void loadJar(JarFile jf) {
        for (Enumeration e = jf.entries();
             e.hasMoreElements();) {
            Object o = e.nextElement();
            String s = o.toString();
            loadClass(s);
        }
    }

    /**
     * <code>loadClass</code> will load a class, at your peril static data
     * members will be automatically invoked upon load using this method.
     * Such elements should probably be invoked from within a thread.
     */
    public static void loadClass(String classString) {
        if (!classString.endsWith(".class")) {
            System.out.println("classString does not end with .class"
                    + classString);
            return;
        }
        String s = makeClassString(classString);
        System.out.println("attempting to load:" + s);
        try {
            Class c = null;
            try {
                c = loadClassName(s);
            } catch (Exception e) {
            }
            if (c == null) return;
            classListBean.add(c);
        } catch (RuntimeException e) {
            System.out.println(classString +
                    ":failed to load");
        }
    }

    /**
     * takes a string of the java/lang/String.class form and returns
     * java.lang.String
     */
    public static String makeClassString(String s) {
        s = StringUtils.sub(s, ".class", "");
        s = s.replace('/', '.');
        s = s.replace('\\', '.');
        //s = ReplaceString.sub(s, "c:.lyon.j4p.classes.", "");
        return s;
    }

    private static Class loadClassName(String s) {
        Class c = null;
        try {
            c = Class.forName(s);
        } catch (Exception e) {
            System.out.println("cant load in loadClassName:" +
                    s);
        }
        return c;
    }

    public static void testGetAClassFromAJar() {
        JarFile jf = getAJarFile();
        JarEntry je[] = getClassEntries(jf);
        for (int i = 0; i < je.length; i++) {
            byte b[] = getByteCodes(jf, je[i]);
            System.out.println(je[i].getName() +
                    " read " +
                    b.length +
                    " bytes");
            Class c = getAClassUntested(b);
            System.out.println("got a class!" + c.getName());
        }
    }

    public static void getClassesWithMain() {
        File f[] = ClassPathUtils.getClassFiles();
        for (int i = 0; i < f.length; i++) {
            ClassFile classFile = ClassFile.getClassFile(f[i]);
            String className = classFile.getClassName();
            Class c = null;
            try {
                c = Class.forName(className);
            } catch (Exception e) {
                continue;
            }
            MethodList ml = new MethodList(c);
            if (ml.hasMainMethod())
                System.out.println(
                        "classes:" + className + " has main method");
        }
    }


    public static Class getAClassUntested(byte b[]) {
        ByteCodeContainer bcc = new ByteCodeContainer(b);
        bcc.loadIt();
        System.out.println("loaded the class");
        return bcc.getLoadedClass();
    }

    public static void testGetBytesCodes() {
        JarFile jf = getAJarFile();
        JarEntry je[] = getClassEntries(jf);
        for (int i = 0; i < je.length; i++) {
            byte b[] = getByteCodes(jf, je[i]);
            System.out.println(je[i].getName() +
                    " read "
                    + b.length + " bytes");
        }
    }

    public static byte[] getByteCodes(JarFile jf,
                                      JarEntry je) {
        byte b[] = new byte[(int) je.getSize()];
        ZipEntry ze = jf.getEntry(je.getName());
        try {
            InputStream is = jf.getInputStream(ze);
            is.read(b);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static void printEntries(JarFile jf) {
        print(getClassEntries(jf));
    }

    public static JarEntry[] getGifEntries(JarFile jf) {
        Vector v = new Vector();
        for (Enumeration e = jf.entries();
             e.hasMoreElements();) {
            Object o = e.nextElement();
            JarEntry je = (JarEntry) o;
            String s = je.getName();
            if (s.endsWith(".gif") &&
                    (-1 == s.indexOf('$')))
                v.addElement(je);
        }
        JarEntry je[] = new JarEntry[v.size()];
        v.copyInto(je);
        return je;
    }

    public static JarEntry[] getClassEntries(JarFile jf) {
        Vector v = new Vector();
        for (Enumeration e = jf.entries();
             e.hasMoreElements();) {
            Object o = e.nextElement();
            JarEntry je = (JarEntry) o;
            String s = je.getName();
            if (s.endsWith(".class") &&
                    (-1 == s.indexOf('$')))
                v.addElement(je);
        }
        JarEntry je[] = new JarEntry[v.size()];
        v.copyInto(je);
        return je;
    }

    public static JarEntry[] getJarEntries(JarFile jf) {
        Vector v = new Vector();
        for (Enumeration e = jf.entries();
             e.hasMoreElements();) {
            Object o = e.nextElement();
            JarEntry je = (JarEntry) o;
            v.addElement(je);
        }
        JarEntry je[] = new JarEntry[v.size()];
        v.copyInto(je);
        return je;
    }

    public static void print(Object s[]) {
        if (s == null) return;
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i]);
        System.out.println("found:" + s.length + " items");
    }

    public static boolean implementsComputableObject(Class c) {
        return implementsComputableObject(c.getInterfaces());
    }

    public static boolean implementsComputableObject(Class s[]) {
        if (s == null) return false;
        for (int i = 0; i < s.length; i++)
            if (s[i].getName().endsWith("ComputableObject"))
                return true;
        return false;
    }

    public static void print(Class s[]) {
        if (s == null) return;
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i].getName());
        System.out.println("found:" + s.length + " Classes");
    }

    public static JarFile[] getJars() {
        String s[] = getClassPaths();
        Vector v = new Vector();
        for (int i = 0; i < s.length; i++)
            try {
                JarFile j = new JarFile(s[i]);
                v.addElement(j);
            } catch (java.io.IOException e) {
            }
        JarFile jf[] = new JarFile[v.size()];
        v.copyInto(jf);
        return jf;
    }

    public static int countJars(String s[]) {
        int n = 0;
        for (int i = 0; i < s.length; i++)
            if (s[i].endsWith("jar")) n++;
        return n;
    }

    public static JarFile getAJarFile() {
        File f =
                futils.Futil.getReadFile("select a jar file");
        JarFile jf = null;
        try {
            jf = new JarFile(f);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return jf;
    }

    public static JarFile[] getJarFiles() {
        DirList dl = new DirList(".jar");
        File f[] = dl.getFiles();
        JarFile jf[] = new JarFile[f.length];
        for (int i = 0; i < jf.length; i++)
            try {
                jf[i] = new JarFile(f[i]);
            } catch (IOException e) {
                System.out.println("could not make jar file out of:" +
                        f[i]);
            }
        return jf;
    }

    public static String[] getLibraryPaths() {
        String s = utils.SystemUtils.getLibraryPath();
        return parsePath(s);
    }

    public static String[] getClassPaths() {
        String cp = getClassPath();
        return parsePath(cp);
    }

    /**
     * Input a path separator delimited set of directories and return one
     * per string element in an array.
     *
     * @param classPath
     * @return
     */
    private static String[] parsePath(String classPath) {
        return classPath.split(System.getProperty("path.separator"));
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    // add new classes for any
    // elements you want loaded.
    private static void loadPackages() {
        loadJars(getJars());
        // loadClasses(getClassFiles());
    }

    private static Package[] getPackages() {
        return Package.getPackages();
    }

    public static void print(Package[] pkgs) {
        SortPackages(pkgs);
        for (int i = 0; i < pkgs.length; i++)
            System.out.println("  " + pkgs[i].getName());
        System.out.println("printed:" +
                pkgs.length +
                " packages.");
    }

    private static void SortPackages(Package[] pkgs) {
        Arrays.sort(pkgs,
                new PackageComparator());
    }

    public static void dumpAClassFile() {
        FileInputStream fis = Futil.getFileInputStream(
                "Select a class file");
        getComputableObjectImplementor(fis);
    }

    public static void dumpClassFile(File f[]) {
        for (int i = 0; i < f.length; i++)
            dumpClassFile(f[i]);
    }

    public static void dumpClassFile(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            Class c = getComputableObjectImplementor(fis);
            if (c != null)
                System.out.println("This class is a ComputableObject" +
                        c.getName());
            fis.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Class getComputableObjectImplementor(
            FileInputStream fis) {
        classUtils.dumper.ByteCodeContainer bcc =
                classUtils.dumper.ByteCodeContainer.getByteCodeContainer(
                        fis);
        bcc.loadIt();
        Class c = bcc.getClass();
        Class interfaces[] = c.getInterfaces();
        for (int i = 0; i < interfaces.length; i++)
            if (interfaces[i].getName().endsWith("ComputableObject"))
                return c;
        return null;
    }

    public static void dumpAllFilesInADirectory() {
        File f[] = Ls.getWildFiles(
                Futil.getReadDirFileJTree("select a class directory"),
                "class");
        dumpClassFile(f);
    }

    public static Class getClassFromFile() throws NotFoundException,
                                                  IOException,
                                                  CannotCompileException {
        File f1 = Futil.getReadFile("select a class file");
        return getClass(f1);
    }

    public static void promptUserForClassName()
            throws ClassNotFoundException,
                   IllegalAccessException,
                   InstantiationException {
        String cn = In.getString("enter a class name");
        Class c = Class.forName(cn);
        In.message(c.newInstance().toString());
    }

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        } catch (ClassNotFoundException e) {
            In.message("in Command getClass:" + e);
        }
        return null;
    }

    public static String[] splitClassName(String clsName) {
        int i = clsName.lastIndexOf('.');
        String[] result = new String[2];
        if (i == -1) {
            result[0] = "";
            result[1] = clsName;
        } else {
            result[0] = clsName.substring(0, i);
            result[1] = clsName.substring(i + 1);
        }
        return result;
    }

    public static String[] getStringArray(String classes) {
        StringTokenizer st = new StringTokenizer(classes, ";, ");
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens())
            array[i++] = st.nextToken();
        return array;
    }

    public static void saveClassPath() {
        Preferences p = Preferences.userRoot();
        p.put(key, getClassPath());
    }
    public static void fixClassPath(){
        PathTabbedPane.fixClassPath();
    }
    public static void restoreClassPath() {
        Preferences p = Preferences.userRoot();
        setClassPath(p.get(key, getClassPath()));
    }


    private static class PackageComparator
            implements Comparator {
        public int compare(Object a, Object b) {
            return ((Package) a).getName()
                    .compareTo(((Package) b).getName());
        }
    }

    static void loadJarEntry(JarFile jf) {
        try {
            ZipEntry ze = jf.getEntry(null);
            jf.getInputStream(ze);
            JarInputStream in = new JarInputStream(
                    new FileInputStream(""));
            //ZipEntry ze=  in.getNextEntry();
            System.out.println("nextEntry is:" + ze);
            byte b[] = new byte[(int) ze.getSize()];
            in.read(b);
            String s = ze.getName();
            if (!s.endsWith(".class")) return;
            System.out.println("loading:" + s);
            ByteCodeContainer bcc = new ByteCodeContainer(b);
            bcc.loadIt();
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setClassPath(String s) {
        System.setProperty("java.class.path", s);
    }
}
