package classUtils.putils;

import futils.DirList;
import futils.Futil;
import utils.StringUtils;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;


/**
 * Copyright DocJava, inc. User: lyon Date: Sep 6, 2004 Time: 10:25:51 AM
 */
public class ClassPathBean implements Serializable {
    private Vector classPathVector = new Vector();
    private String pathSeparator = System.getProperty("path.separator");

    private static final String key = "ClassPathBean";

    public ClassPathBean() {
        String classPaths[] = ClassPathUtils.getClassPaths();
        for (int i = 0; i < classPaths.length; i++)
            classPathVector.addElement(classPaths[i]);
    }
    /**
     * Converts a fully qualified externalized java class name into a
     * relative file path.
     *
     * @param className the name of the class to find
     * @return the system-dependent path name for the class
     */
    private static String classNameToPath(String className) {
        if (className == null) return null;
        if (className.endsWith(".class"))
            className = StringUtils.stripSuffix(className,".class");
        return className.replace('.', File.separatorChar) + ".class";
    }

    private static void testClassNameToPath(){
        System.out.println("ij.ImageJ:"+classNameToPath("ij.ImageJ"));
        System.out.println("ImageJ:" + classNameToPath("ImageJ"));
        System.out.println("ij.ImageJ.class:" + classNameToPath("ij.ImageJ.class"));
    }
    public static void main(String[] args) {
        //testClassNameToPath();
        updatePreferencesWithCurrentPath();
        final ClassPathBean o = ClassPathBean.restore();
        System.out.println("classes:");
        final File[] allClassFilesInDirs = o.getAllClassFilesInDirs();
        File f = o.findClass("ij.ImageJ");
        if (f==null) o.addDirectoryToPath();
        o.save();
        f = o.findClass("ij.ImageJ");
        System.out.println("ij.ImageJ="+f);
        final String name = o.getClass().getName();
        f = o.findClass(name+".class");

        System.out.println(name+"=" + f);
        System.out.println("done");
    }
    public File findClass(String className){
        String path = classNameToPath(className);
        File dirs[] = getDirs();
        for (int i=0; i < dirs.length; i++){
            File f = new File(dirs[i],path);
            if (f.exists()) return f;
        }
        return null;
    }

    public void addDirectoryToPath() {
        // if you got this far, we could not find the
        // the class in the class files.
        // what should we do?
        final File readFileDir =
                Futil.getReadFileDir("enter a class folder").getParentFile();
        System.out.println("adding "+readFileDir+" to classPath");
        classPathVector.addElement(
                readFileDir.getAbsolutePath());
    }


    public static void print(Object o[]){
        for (int i=0; i < o.length; i++)
            System.out.println(o[i]);
    }
    /**
     * This will wipe out the old paths stored in preferences, in favor of
     * the new path.
     */
    public static void updatePreferencesWithCurrentPath() {
        ClassPathBean cpb = new ClassPathBean();
        cpb.save();
        System.out.println(cpb.getClassPath());
    }

    public String getClassPath() {
        return toString();
    }

    public Enumeration getPathEnumeration() {
        return classPathVector.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        final String[] classPaths = getClassPaths();
        for (int i = 0;
             i < classPaths.length;
             i++) {
            sb.append(classPaths[i]);
            sb.append(pathSeparator);
        }
        return sb.toString();
    }

    public String[] getClassPaths() {
        String s[] = new String[classPathVector.size()];
        classPathVector.copyInto(s);
        return s;
    }

    /**
     * append a path (with no delimeters) to the internall held vector. Can
     * be a dir or a jar.
     */
    public void addClassPath(String path) {
        classPathVector.addElement(path);
    }

    /**
     * Overwrite the internally held vector.
     */
    public void setClassPaths(String classPaths[]) {
        classPathVector = new Vector();
        for (int i = 0; i < classPaths.length; i++)
            classPathVector.addElement(classPaths[i]);
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static ClassPathBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new ClassPathBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (ClassPathBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new ClassPathBean();
    }

    /**
     * Get all the readable files with a .jar suffix
     */
    public File[] getJars() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            if (s.endsWith(".jar") && (f.canRead()))
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    public File[] getAllClassFilesInDirs() {
        Vector v = new Vector();
        File dirs[] = getDirs();
        System.out.println("found dirs:");
        print(dirs);
        for (int i = 0; i < dirs.length; i++) {
            DirList dl = new DirList(dirs[i], ".class");
            File files[] = dl.getFiles();
            for (int j=0; j < files.length; j++){
                v.addElement(files[j]);
            }
        }
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    /**
     * Get all the dirs
     */
    public File[] getDirs() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);


            if (f.isDirectory())
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Get all the readable files with a .zip suffix
     */
    public File[] getJarsAndZips() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            final boolean isZip = s.endsWith(".zip");
            final boolean isJar = s.endsWith(".jar");
            if ((isZip || isJar) && f.canRead())
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Get all the readable files with a .zip suffix
     */
    public File[] getZips() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            if (s.endsWith(".zip") && (f.canRead()))
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Erase internally held class path and erase it with the long path
     * delimited string.
     */
    public void setClassPath(java.lang.String classPath) {
        classPathVector = new Vector();
        StringTokenizer st =
                new StringTokenizer(
                        classPath,
                        pathSeparator);
        int n = st.countTokens();
        for (int i = 0; i < n; i++)
            classPathVector.addElement(st.nextToken());
    }

    public URL[] getClassPathUrls() {
        String s[] = this.getClassPaths();
        Vector v = new Vector();
        for (int i = 0; i < s.length; i++)
            try {
                v.addElement(new URL(s[i]));
            } catch (MalformedURLException e) {

            }
        URL u[] = new URL[v.size()];
        v.copyInto(u);
        return u;
    }

    public void printJars() {
        File f[] = getJars();
        for (int i = 0; i < f.length; i++)
            System.out.println("jar:" + f[i].getAbsolutePath());
    }
}
