package classUtils.pack.util;


/**
 * A {@link classUtils.pack.util.ResourceFinderInterface
 * ResourceFileFinder} which allows to dynamically redefine the class
 * path.
 * <p/>
 * The redefinition may or may not affect reloading of already linked
 * classes.
 *
 * @author cris
 */
public interface DynamicResourceFinderInterfaceInterface
        extends ResourceFinderInterface {

    public void addClassPathEntry(String entry);

    public void setClassPath(String classPath);

    public String getClassPath();

}
