package bookExamples.ch34BeanProperties;

import gui.ClosableJFrame;
import gui.In;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 23, 2005
 * Time: 1:41:58 PM
 * Copyright DocJava, 2005
 */
public class IntegerEditor implements PropertyEditor {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Integer value = new Integer(0);
    private int lo = 0;
    private int hi = 10;
    private String prompt = "enter an integer";


    public boolean isPaintable() {
        return true;
    }

    public void setPrompt(String prompt, int lo, int hi) {
        this.prompt = prompt;
        this.lo = lo;
        this.hi = hi;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new RunButton("...") {
            public void run() {
                setValue(new Integer(In.getInt(prompt, lo, hi)));
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);

    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public Object getValue() {
        return value;

    }

    public void setValue(Object newValue) {
        if (this.value.equals(newValue)) return;
        pcs.firePropertyChange(new PropertyChangeEvent(this, prompt, value, newValue));
        this.value = (Integer) newValue;
    }

    public String getAsText() {
        return value.toString();
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    /**
     * Map the argument text into an Integer using Integer.valueOf.
     */

    public void setAsText(final String text) {
        Object newValue = Integer.valueOf(text);
        setValue(newValue);
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        JLabel jl = new JLabel(getAsText());
        jl.setSize(box.getSize());
        jl.setLocation(box.getLocation());
        jl.paint(gfx);
    }

    public static void main(String[] args) {
        IntegerEditor ie = new IntegerEditor();
        ie.setPrompt("enter a number between 0 and 10", 0, 10);
        Integer v = (Integer)ie.getValue();
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());

        final JLabel jl = new JLabel(v.toString());
        PropertyChangeListener pcl = new PropertyChangeListener(){
            public void propertyChange(PropertyChangeEvent pce){
                System.out.println("pce:"+pce.getNewValue());
                 jl.setText(pce.getNewValue().toString());
            }
        };

        c.add(jl);
        c.add(ie.getCustomEditor());
        ie.addPropertyChangeListener(pcl);
        cf.setSize(200, 200);
        cf.setVisible(true);
    }
}
