package bookExamples.ch26Graphics.draw2d;

import java.awt.*;

public class SquareShape2 extends DJShape {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new SquareShape2(x1, y1, x2, y2);
    }

    public int getX1() {
        return x1;
    }

    public int getY1() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public SquareShape2(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }
    public Point getCenter(){
       return new Point(x1+w/2,y1+w/2);
    }
    public void draw(Graphics g) {
        Color saveColor = g.getColor();
        if (isSelected())
            g.setColor(Color.BLUE);
        Point pc = getCenter();
        xc = (int)pc.getX();
        yc = (int)pc.getY();
        g.drawRect(x1, y1, w,w);
        g.fillOval(xc, yc, 2, 2);
        g.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        g.setColor(saveColor);
    }
}
