package bookExamples.ch26Graphics.draw2d;

import gui.In;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

/**
 * Created by IntelliJ IDEA.
 * User: Keith Shaffer
 * Date: Feb 3, 2005
 * Time: 6:21:16 PM
 * To change this template use File | Settings | File Templates.
 */
public class RtTriangle2d extends DJShape implements PropertyEditor {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    public String toString() {
        return h + "," + w + "," + xc + "," + yc;
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new bookExamples.ch26Graphics.draw2d.RtTriangle2d(x1, y1, x2, y2);
    }

    public int getX() {
        return x1;
    }

    public int getY() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public RtTriangle2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }

    public void draw(Graphics g) {
        Point2D pc = getCenter();
        int x = (int) pc.getX();
        int y = (int) pc.getY();

        Graphics2D g2d = (Graphics2D) g;
        AffineTransform old = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();
        g2d.transform(affineTransform);
        g2d.setColor(getForeground());
        g2d.drawLine(x1, y1 + h, x1, y1);
        g2d.drawLine(x1, y1, x1 + w, y1);
        g2d.drawLine(x1, y1 + h, x1 + w, y1);
        g2d.fillOval(xc, yc, 2, 2);
        g2d.drawString("(" + x + "," + y + ")", x + 3, y + 3);
        g2d.setTransform(old);

    }

    public Point getCenter() {
        Point2D p1 = new Point2D.Float(x1, y1);
        Point2D p2 = new Point2D.Float(x1 + w, y1);
        Point2D p3 = new Point2D.Float(x1, y1 + h);
        int x1_ = (int) p1.getX();
        int x2_ = (int) p2.getX();
        int x3_ = (int) p3.getX();
        int y1_ = (int) p1.getY();
        int y2_ = (int) p2.getY();
        int y3_ = (int) p3.getY();
        xc = (x1_ + x2_ + x3_) / 3;
        yc = (y1_ + y2_ + y3_) / 3;
        return new Point(xc, yc);
    }

    public boolean isPaintable() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public final void update() {
        pcs.firePropertyChange("Right Triangle", this, null);
    }

    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.add(new RunButton("setForeground") {
            public void run() {
                Color c = In.getColor();
                RtTriangle2d.this.update();
                RtTriangle2d.this.setForeground(c);
            }
        });

        jp.add(getRunAffinePanel());

        jp.setLayout(new FlowLayout());
        return jp;
    }

    public Object getValue() {
        return this;
    }

    public void setValue(Object value) {

    }

    public String getAsText() {
        return toString();
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}


