package bookExamples.ch26Graphics.draw2d;

import java.awt.*;
import java.beans.PropertyChangeListener;

public class Rect2d extends DJShape implements Intersects {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;
       public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Rect2d(x1, y1, x2, y2);
    }
    public Point getCenter(){
        return new Point(xc,yc);
    }
    public int getX1() {
        return x1;
    }
   public Point getNearestEdge(Point dp) {
        Rectangle sr = new Rectangle(getX1(),getY1(),w,h);
        Point sp = getCenterPoint();
        int dx = dp.x - sp.x;
        int dy = dp.y - sp.y;
        double a = Math.abs(dy / (double) dx);
        double b = Math.abs(sr.height / (double) sr.width);
        if (a < b) {
            sp.x += sr.width / 2 * ((dx < 0) ? -1 : 1);
            sp.y += sr.width / 2 * a * ((dy < 0) ? -1 : 1);
        } else {
            sp.y += sr.height / 2 * ((dy < 0) ? -1 : 1);
            sp.x += sr.height / 2 / a * ((dx < 0) ? -1 : 1);
        }
        return sp;
    }

    public int getY1() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }

    public Rect2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1,_y1,_x2,_y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }


    public void draw(Graphics g) {
        g.drawRect(x1, y1, w, h);
        g.fillOval(xc, yc, 2, 2);
        g.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        Point pc = getCenterPoint();
        Circle2d c = new Circle2d(pc.x, pc.y, w);
        c.draw(g);
    }

    public Vec2d intersect(Ray2d r) {
        Point pc = getCenterPoint();
        Circle2d c = new Circle2d(pc.x, pc.y,w);
        return c.intersect(r);
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
