/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package bookExamples.ch26Graphics.draw2d;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Feb 20, 2005
 * <p/>
 * Time: 7:59:45 AM
 */
 public class FunctionShape
        extends DJShape
        implements PropertyChangeListener {
    private Fcn1 f;
    private double eps;
    private GeneralPath gp = new GeneralPath();

    public FunctionShape(int x1,
                         int y1,
                         int x2,
                         int y2,
                         Fcn1 f,
                         double eps) {
        super(x1, y1, x2, y2);
        init(f, eps);
    }

    private void init(Fcn1 f, double eps) {
        // this is the mediator.
        if (f instanceof PropertyEditor){
            PropertyEditor pe = (PropertyEditor)f;
            pe.addPropertyChangeListener(this);
        }
        this.f = f;
        this.eps = eps;
        setGeneralPath(f, eps);
    }

    private void setGeneralPath(Fcn1 f, double eps) {
        gp = new GeneralPath();
        Point2D point = f.getPoint(0);
        gp.moveTo((float) point.getX()+x1, (float) point.getY()+y1);
        for (double t = 0; t <= 1; t = t + eps) {
            point = f.getPoint(t);
            gp.lineTo((float) point.getX()+x1, (float) point.getY()+y1);
        }
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        return new FunctionShape(x1, y1, x2, y2, f, eps);

    }

    public Shape getShape() {
        return gp;
    }
    public void propertyChange(PropertyChangeEvent pce){
        Object src = pce.getSource();
        f = (Fcn1)src;
        setGeneralPath(f, eps);
    }
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        g2d.draw(getTransformedShape());
        Point pc = getCenter();
        g2d.drawString("(" + pc.x + "," + pc.y + ")", pc.x + 3, pc.y + 3);
    }
    public Point getCenter(){
        Shape s = getTransformedShape();
        Rectangle r = s.getBounds();
        return new Point(r.width/2+r.x,r.height/2+r.y);

    }
    private Shape getTransformedShape() {
        int w = x2 - x1;
        int h = y2 - y1;
        Rectangle r = gp.getBounds();
        double sx = w / r.getWidth();
        double sy = h / r.getHeight();
        AffineTransform atr = new AffineTransform();
        atr.setToTranslation(x1, y1);
        atr.scale(sx, sy);
        atr.translate(-x1, -y1);
        Shape transformedShape = atr.createTransformedShape(gp);
        return transformedShape;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
