package bookExamples.ch26Graphics.draw2d;

import gui.run.RunAffinePanel;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class DJShape
        implements Drawable, HasShape {
    int x1 = 0;
    int y1 = 0;
    int x2 = 1;
    int y2 = 1;
    RunAffinePanel rap = new RunAffinePanel() {
        public void run() {
            DJShape.this.setAffineTransform(getValue());
            pcs.firePropertyChange("DjShape", DJShape.this, null);
        }
    };
    AffineTransform at = new AffineTransform();
    private boolean selected = false;
    private Color foregroundColor = Color.black;
    private Color background = Color.WHITE;
    private Dimension size = new Dimension(200, 200);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);


    public int getX1() {
        return x1;
    }

    public int getY1() {
        return y1;
    }

    public abstract DJShape getInstance(int x1, int y1, int x2, int y2);

    public void setLocation(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public DJShape(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        at.setToIdentity();
    }

    public void erase(Frame f, Graphics g) {
        g.setXORMode(f.getBackground());
        draw(g);
        g.setColor(f.getForeground());
        g.setPaintMode();
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }


    public void setAffineTransform(AffineTransform at) {
        this.at = at;
    }

    public AffineTransform getAffineTransform() {
        return at;
    }


    public abstract Point getCenter();

    public double getDistance(Point2d p) {
        Point2D pc = getCenter();
        double dx = Math.abs(p.getX1() - pc.getX());
        double dy = Math.abs(p.getY1() - pc.getY());
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static void drawLine(Point2D p1, Point2D p2, Graphics g) {
        g.drawLine((int) p1.getX(), (int) p1.getY(), (int) p2.getX(), (int) p2.getY());
    }

    public Point getCenterPoint() {
        Point2D p = getCenter();
        return new Point((int) p.getX(), (int) p.getY());
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        setForeground(Color.blue);
    }

    public void restoreState(Graphics2D g2d) {
        g2d.setColor(Color.black);
    }

    public Color getBackground() {
        return background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
    }

    public Color getForeground() {
        return foregroundColor;
    }

    public Dimension getSize() {
        return size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Shape getShape() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    protected RunAffinePanel getRunAffinePanel() {
        return rap;
    }
}