//package cone2dPackage;
package bookExamples.ch26Graphics.draw2d;

import gui.In;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;

/**
 * Created by IntelliJ IDEA.
 * User: Gino Lopes
 * Date: Feb 12, 2005
 * Time: 5:16:33 PM
 * To change this template use File | Settings | File Templates.
 * /
 * <p/>
 * /*Creates a cone based on the starting mouse click as the center of cone.
 */

public class Cone2d extends DJShape
        implements PropertyEditor{
    int diameter = 1;
    double xc, yc;

    Polygon p = new Polygon();

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Cone2d(x1, y1, x2, y2);
    } // end getInstance()

    public Cone2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        x1 = _x1;
        y1 = _y1;
        int dx = x1 - _x2;
        int dy = y1 - _y2;
        diameter = (int) Math.sqrt(dx * dx + dy * dy);
        if (_x1 > _x2) x1 = _x2;
        if (_y1 > _y2) y1 = _y2;
        setCenter();
        createPolygon();
    } // end Cone2d()

    private void setCenter() {
        int radius = diameter / 2;
        xc = x1 + radius;
        yc = y1 + radius;
    } // end setCenter

    public Point getCenter() {
        return new Point((int) xc, (int) yc);
    } // end getCenter

    public void createPolygon(){
        // creates shape
        Point2D p1 = getPoint(1 - 0.25);
        p.addPoint((int) p1.getX(), (int) p1.getY());
        double v = (0.25 + 1 / 3.0);
        for (double i = (1 - v); i > (1 - (v + 1 / 3.0)); i -= 0.001) {
            Point2D p2 = getPoint(i);
            p.addPoint((int) p2.getX(), (int) p2.getY());
        } // end for loop
    } // end createPolygon

    public Point2D getPoint(double t) {
        Point pc = getCenter();
        int radius = diameter / 2;
        t = 2 * Math.PI * t;
        float x = (float) (radius * Math.cos(t) + pc.x);
        float y = (float) (radius * Math.sin(t) + pc.y);
        return new Point2D.Float(x, y);
    } // end getPoint

    public void draw(Graphics g) {
        Point pc = getCenter();

        Graphics2D g2d = (Graphics2D) g;
        AffineTransform saveAt = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();

        // save the default color
        Color saveColor = g2d.getColor();
        // sets the color of the shape
        g2d.setColor(getForeground());

        g2d.transform(affineTransform);
        g2d.drawPolygon(p);

        //Shape shape = affineTransform.createTransformedShape(p);
        //g2d.draw(p);
        //g2d.draw(shape);
        //g2d.drawOval(x1, y1, diameter, diameter);

        // displays center point of cone
        g2d.fillOval(pc.x, pc.y, 2, 2);
        // displays the location of the center xy coordinates
        g2d.drawString("(" + pc.x + "," + pc.y + ")", pc.x + 3, pc.y + 3);

        g2d.setTransform(saveAt);
        // restores the color of the shape to the default color
        g2d.setColor(saveColor);
        // refreshes the drawn shape to the current state
        restoreState(g2d);
    } // end drawTransformedShape

    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("setForeground") {
            public void run() {
                Cone2d.this.setForeground(In.getColor());
                pcs.firePropertyChange("conehead", Cone2d.this, null);
            }
        });
        jp.add(getRunAffinePanel());
        return jp;
    } // end getCustomEditor

    public boolean isPaintable() {
        return true;
    } // end isPaintable

    public String toString() {
        Point pc = getCenter();
        int radius = diameter / 2;
        return "xc, yc, radius =" + pc.x + ", " + pc.y + ", " + radius + " shape=Cone2d";
    } // end toString

    public boolean supportsCustomEditor() {
        return true;
    } // end supportsCustomEditor

    public Object getValue() {
        return this;
    } // end getValue

    public void setValue(Object newValue) {
    } // end setValue

    public String getAsText() {
        return null;
    } // end getAsText

    public String getJavaInitializationString() {
        return null;
    } // end getJavaInitializationString

    public String[] getTags() {
        return null;
    } //end getTags

    public void setAsText(String text) throws IllegalArgumentException {
    } // end setAsText

    public void paintValue(Graphics gfx, Rectangle box) {
    } // end paintValue
} // end class Cone2d
