package bookExamples.ch12Nested;

public class ThisTest {
    public static void main(String args[]) {
         ThisTest tt;
        tt = new ThisTest();
        tt.print();
        tt = new ThisTest() {
            public String toString() {
                return "anonymous local inner class from a non-abstract outer class";
            }
        };
        tt.print();
        class ThatTest extends ThisTest {
            ThisTest anotherTest ;
            ThatTest(ThisTest anInstanceOfThisTest) {
                anotherTest = anInstanceOfThisTest;
            }
            public String toString() {
                return "thatTest is a local named inner class+"+ super.toString()
                        + anotherTest.toString();
            }
        }
        ThatTest tt2 = new ThatTest(tt);
        tt2.print();

    }

    public void print() {
        System.out.println(this);
    }

    public String toString() {
        return "Hello from ThisTest!!";
    }
}

class Constructor {
    int x,y;

    Constructor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    Constructor() {
        this(10, 20); // default values
    }

    void print() {
        System.out.println("x,y=" + x + "," + y);
    }

    public static void main(String args[]) {
        Constructor c = new Constructor();
        c.print();
    }
}

class OuterThis {
    int x = 10;
    Inner i = new Inner();

    public static void main(String args[]) {
        OuterThis o = new OuterThis();
        o.i.print();
    }

    class Inner {
        int x = 20;

        void print() {
            System.out.println("inner x= " + x);
            System.out.println("outer x= " + OuterThis.this.x);
        }
    }
}

