/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.print.dymo;

import graphics.FontUtils;
import gui.In;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 22, 2005
 * <p/>
 * Time: 10:24:35 AM
 */
public class DymoLabelPrintTest  extends JPanel {
        private int fontSize = 90;
        private String message ;
        private int messageWidth;

        public DymoLabelPrintTest(String message) {
            this.message = message;
            setBackground(Color.white);
            String[] fontNames = FontUtils.getFontNames();
            String fn = (String)
                    In.multiPrompt(fontNames,
                            "select a font","font selector");
            int size = In.getInt("enter a font size", 1, 255);
            Font f = new Font(fn,Font.ITALIC,size);
            setFont(f);
            FontMetrics metrics = getFontMetrics(f);
            messageWidth = metrics.stringWidth(message);
            int width = messageWidth * 5 / 3;
            int height = fontSize * 3;
            setPreferredSize(new Dimension(width, height));
        }

    /**
         * Draws a black string with a tall angled "shadow" of the string
         * behind it.
         */
        public void paintComponent(Graphics g) {

            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D) g;

            int x = messageWidth / 10;
            int y = fontSize * 5 / 2;
            g2d.translate(x, y);
            g2d.setPaint(Color.lightGray);
            AffineTransform origTransform = g2d.getTransform();
            g2d.shear(-0.95, 0);
            g2d.scale(1, 3);
            g2d.drawString(message, 0, 0);
            g2d.setTransform(origTransform);
            g2d.setPaint(Color.black);
            g2d.drawString(message, 0, 0);
        }
    }