package addbk.print;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 22, 2005
 * <p/>
 * Time: 10:24:35 AM
 */
public class J2dPrintTest extends JPanel {
    private int fontSize = 90;
    private String message = "Java 2D";
    private int messageWidth;

    public J2dPrintTest() {
        setBackground(Color.white);

        Font f = new Font("Times", Font.ITALIC, 72);
        setFont(f);
        FontMetrics metrics = getFontMetrics(f);
        messageWidth = metrics.stringWidth(message);
        int width = messageWidth * 5 / 3;
        int height = fontSize * 3;
        setPreferredSize(new Dimension(width, height));
    }

    /**
     * Draws a black string with a tall angled "shadow" of the string
     * behind it.
     */
    public void paintComponent(Graphics g) {

        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g;

        int x = messageWidth / 10;
        int y = fontSize * 5 / 2;
        g2d.translate(x, y);
        g2d.setPaint(Color.lightGray);
        AffineTransform origTransform = g2d.getTransform();
        g2d.shear(-0.95, 0);
        g2d.scale(1, 3);
        g2d.drawString(message, 0, 0);
        g2d.setTransform(origTransform);
        g2d.setPaint(Color.black);
        g2d.drawString(message, 0, 0);
    }
}