package addbk.JAddressBook;

import javax.swing.table.AbstractTableModel;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 6, 2004
 * <p/>
 * Time: 7:12:33 AM
 */
public class TableData {
    private String columnNames[];
    private Object data[][];
    private final GeneralTableModel tableModel = new GeneralTableModel();

    public TableData(String columnNames[], Object data[][]) {
        this.columnNames = columnNames;
        this.data = data;
    }

    public GeneralTableModel getTableModel() {
        return tableModel;
    }

    private class GeneralTableModel extends AbstractTableModel {
        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            return data.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        /*
        * JTable uses this method to determine the default renderer/
        * editor for each cell.  If we didn't implement this method,
        * then the last column would contain text ("true"/"false"),
        * rather than a check box.
        */
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }

        /*
        * Don't need to implement this method unless your table's
        * editable.
        */
        public boolean isCellEditable(int row, int col) {
            //Note that the data/cell address is constant,
            //no matter where the cell appears onscreen.
            if (col < 2) {
                return false;
            } else {
                return true;
            }
        }

        /*
        * Don't need to implement this method unless your table's
        * data can change.
        */
        public void setValueAt(Object value, int row, int col) {
            data[row][col] = value;
            fireTableCellUpdated(row, col);
        }
    }
}

