//Paul S. Underwood
//SW409 Final Exam
//May 3, 2005

//Borrowed from Chapter 44 stuff

package addbk.JAddressBook;

import gui.run.LabelBean;

import java.awt.*;
import java.awt.print.*;

public class LabelPrinter implements Pageable {
    private static final int INCH = 72;
    private LabelBean lb = LabelBean.restore();
    private Font font;
    private AddressDataBase adb;
    private PrinterJob pJob;

    public int getNumberOfPages() {
        int pages = adb.getSize() / lb.getNumberOfLabels();
        if (adb.getSize() % lb.getNumberOfLabels() != 0) {
            ++pages;
        }
        return pages;
    }

    //Support functions for Pageable interface
    public Printable getPrintable(int pageIndex) {
        return new PrintableLabel(adb, font);
    }

    public PageFormat getPageFormat(int pageIndex) {
        //just does the default: portrait
        return new PageFormat();
    }

    public LabelPrinter(AddressDataBase db, Font f) {
        adb = db;
        font = f;
        pJob = PrinterJob.getPrinterJob();
        pJob.setPageable(this);
        displayPrintDialog(pJob, db);
    }

    private void displayPrintDialog(PrinterJob pJob, AddressDataBase v) {
        if (pJob.printDialog()) {
            print(v, pJob);
            try {
                print(pJob);
            } catch (PrinterException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void print(final PrinterJob pJob)
            throws PrinterException {
        pJob.print();

    }

    public void print(AddressDataBase db, PrinterJob pj) {
        //set up a format
        PageFormat fmt = pj.defaultPage();
        //define the orientation
        fmt.setOrientation(PageFormat.PORTRAIT);
        //set the paper size
        Paper paper = fmt.getPaper();
        paper.setSize(8.5 * INCH, 11 * INCH);
        //define the full area as imageable
        paper.setImageableArea(0 * INCH, 0 * INCH, 8.5 * INCH, 11 * INCH);
        //set this paper as the current format
        fmt.setPaper(paper);

        //showAndRegister the page format dialog for the heck of it
        //pj.pageDialog(fmt);
        //create a printable page
        pj.setPrintable(new addbk.JAddressBook.PrintableLabel(db, font), fmt);
    }
}
