/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;


import net.web.UrlUtils;
import utils.StringUtils;

import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 17, 2005
 * <p/>
 * Time: 4:45:49 AM
 */
public class AddressUrlUtils {
    public static AddressDataBase abd = AddressDataBase.getAddressBookDatabase();

    public static Vector lookForIPLawyersInCt(int pageNumber) {
        String s2 =
                "http://www.lawyers.com/find_a_lawyer/search/results.php?country=1&firmname=&firstname=&lastname=&searchtype=Q&termtype=1&personalaop=756&personalterm=&businessaop=&businessterm=&language=&pagenum=&city=&county=&" +
                "state=7&country=1&site=466&lm_id=&resultcount=126&sed=2487187&displaycount=126&sorttype=0" +
                "&pagenum=" +
                pageNumber;
        return UrlUtils.getUrlVector(s2);
    }

    public static Vector lookForComputerCompanies(int pageNumber,String state) {
        String s2 =
                "http://www.yellowpages.com/SearchResult.aspx?" +
                "search=Data+Processing+Services&" +
                "searchfor=computer&typeorname=type&method=and&" +
                "page=&searchform=&searchcategory=1304&" +
                "state=" +
                state +
                "&city=&distance=&street=&zipcode=&" +
                "areacode=&firstchar=&narrowzip=&startposition=" +
                pageNumber*16;
        return UrlUtils.getUrlVector(s2);
    }

    public static void scanForLawyers() {
        for (int i = 1; i < 8; i++) {
            Vector v = lookForIPLawyersInCt(i);
            insertIntoDatabase(v);
        }
    }

    public static void scanForComputerCompanies() {
        for (int i = 1; i < 8; i++) {
            Vector v = lookForComputerCompanies(i,"CT");
            insertIntoDatabase(v);
        }
    }

    public static void insertIntoDatabase(Vector v) {
        String name = null;
        String city = null;
        String state = null;
        String street = null;
        String address = null;

        AddressRecord ar = new AddressRecord();

        // Each element of the vector is an HTML line.
        for (int i = 0; i < v.size(); i++) {

            String s = (String) v.elementAt(i);
            // The line with class='sponseredL'> should be analyzed.
            if ((s.indexOf("class='sponseredL'>More Info") == -1) &&
                    (s.indexOf("class='sponseredL'>") > -1)) {
                int j = 0;
                j = s.indexOf("class='sponseredL'>") + 19; // 19 is the length of this string.

                name = s.substring(j, s.indexOf("</a></strong><br>")); // Name.

                s = s.substring(s.indexOf("</a></strong><br>") + 17); // trim the string.
                j = s.indexOf("<B>");
                // Street addresses end with <B>.
                // If <B> does not exist, then no address is given.
                if (j == -1) {
                    // Address does not exist.

                    continue;
                }

                street = s.substring(0, s.indexOf("<B>") - 2).trim(); // -1 is for comma.

                s = s.substring(s.indexOf("<B>") + 3); // trim the string.
                city = s.substring(0, s.indexOf("</B>")).trim();
                s = s.substring(s.indexOf("</B>") + 5); // trim the string.

                state = s.substring(0, s.indexOf("<")).trim();
                address = filterStreet(street) +
                        "\n" +
                        city +
                        ", " +
                        filterStateZipCountry(state);

                // Feed the AddressRecord object.
                ar = new AddressRecord();
                ar.setName(name);
                ar.setAddress(address);
                abd.addRecord(ar);
            }
        }

    }

    public static String filterStreet(String s) {
        String counties[] = {
            "Middlesex Co.",
            "Fairfield Co.",
            "New Haven Co.",
            "New London Co.",
            "Hartford Co."
        };
        s = StringUtils.replaceAll(s, counties, "");
        return s;
    }

    //todo map all full state names into two letter names.
    public static String filterStateZipCountry(String s) {
        s = StringUtils.replaceAll(s, "U.S.A.", "");
        int i = s.indexOf(" ");
        String state =
                getTwoLetterStateAbbreviation(
                        s.substring(0, i).toUpperCase().trim());
        String zip = s.substring(i, s.length() - 1);
        s = state + " " + zip;
        System.out.println(s);
        return s;
    }

    public static String getTwoLetterStateAbbreviation(String s) {
        s = StringUtils.replaceAll(s, "ALABAMA", "AL");
        s = StringUtils.replaceAll(s, "ALASKA", "AK");
        s = StringUtils.replaceAll(s, "ARIZONA", "AZ");
        s = StringUtils.replaceAll(s, "ARKANSAS", "AR");
        s = StringUtils.replaceAll(s, "CALIFORNIA", "CA");
        s = StringUtils.replaceAll(s, "COLORADO", "CO");
        s = StringUtils.replaceAll(s, "CONNECTICUT", "CT");
        s = StringUtils.replaceAll(s, "DELAWARE", "DE");
        s = StringUtils.replaceAll(s, "DISTRICT OF COLUMBIA", "DC");
        s = StringUtils.replaceAll(s, "FLORIDA", "FL");
        s = StringUtils.replaceAll(s, "GEORGIA", "GA");
        s = StringUtils.replaceAll(s, "GUAM", "GU");
        s = StringUtils.replaceAll(s, "HAWAII", "HI");
        s = StringUtils.replaceAll(s, "IDAHO", "ID");
        s = StringUtils.replaceAll(s, "ILLINOIS", "IL");
        s = StringUtils.replaceAll(s, "INDIANA", "IN");
        s = StringUtils.replaceAll(s, "IOWA", "IA");
        s = StringUtils.replaceAll(s, "KANSAS", "KS");
        s = StringUtils.replaceAll(s, "KENTUCKY", "KY");
        s = StringUtils.replaceAll(s, "LOUISIANA", "LA");
        s = StringUtils.replaceAll(s, "MAINE", "ME");
        s = StringUtils.replaceAll(s, "MARYLAND", "MD");
        s = StringUtils.replaceAll(s, "MASSACHUSETTS", "MA");
        s = StringUtils.replaceAll(s, "MICHIGAN", "MI");
        s = StringUtils.replaceAll(s, "MINNESOTA", "MN");
        s = StringUtils.replaceAll(s, "MISSISSIPPI", "MS");
        s = StringUtils.replaceAll(s, "MISSOURI", "MO");
        s = StringUtils.replaceAll(s, "MONTANA", "MT");
        s = StringUtils.replaceAll(s, "NEBRASKA", "NE");
        s = StringUtils.replaceAll(s, "NEVADA", "NV");
        s = StringUtils.replaceAll(s, "OHIO", "OH");
        s = StringUtils.replaceAll(s, "OKLAHOMA", "OK");
        s = StringUtils.replaceAll(s, "OREGON", "OR");
        s = StringUtils.replaceAll(s, "PALAU", "PW");
        s = StringUtils.replaceAll(s, "PENNSYLVANIA", "PA");
        s = StringUtils.replaceAll(s, "PUERTO RICO", "PR");
        s = StringUtils.replaceAll(s, "RHODE ISLAND", "RI");
        s = StringUtils.replaceAll(s, "SOUTH CAROLINA", "SC");
        s = StringUtils.replaceAll(s, "SOUTH DAKOTA", "SD");
        s = StringUtils.replaceAll(s, "TENNESSEE", "TN");
        s = StringUtils.replaceAll(s, "TEXAS", "TX");
        s = StringUtils.replaceAll(s, "UTAH", "UT");
        s = StringUtils.replaceAll(s, "VERMONT", "VT");
        s = StringUtils.replaceAll(s, "VIRGIN ISLANDS", "VI");
        s = StringUtils.replaceAll(s, "VIRGINIA", "VA");
        s = StringUtils.replaceAll(s, "WASHINGTON", "WA");
        s = StringUtils.replaceAll(s, "WEST VIRGINIA", "WV");
        s = StringUtils.replaceAll(s, "WISCONSIN", "WI");
        s = StringUtils.replaceAll(s, "WYOMING", "WY");
        s = StringUtils.replaceAll(s, "NEW HAMPSHIRE", "NH");
        s = StringUtils.replaceAll(s, "NEW JERSEY", "NJ");
        s = StringUtils.replaceAll(s, "NEW MEXICO", "NM");
        s = StringUtils.replaceAll(s, "NEW YORK", "NY");
        s = StringUtils.replaceAll(s, "NORTH CAROLINA", "NC");
        s = StringUtils.replaceAll(s, "NORTH DAKOTA", "ND");
        return s;
    }
}
