package xml.cart;

import xml.Product;

import java.util.Vector;

public class Cart {
    private Vector goodies = new Vector();

    public void addProduct(Product p) {
        if (p == null) return;
        goodies.addElement(p);
    }

    public void removeProduct(Product p) {
        goodies.removeElement(p);
    }

    public Product[] getProducts() {
        Product[] pa = new Product[goodies.size()];
        goodies.copyInto(pa);
        return pa;
    }

    public String toString() {
        Product p[] = getProducts();
        String s = "cart:\n";
        for (int i = 0; i < p.length; i++)
            s = s + p[i].toString() + '\n';
        s = s + "total:" + getTotal();
        return s;
    }

    public float getTotal() {
        Product p[] = getProducts();
        float t = 0;
        for (int i = 0; i < p.length; i++)
            t = t + p[i].getPrice();
        return t;
    }

    public static void main(String args[]) {
        Product p = new Product(
                "Image Processing in Java", 25f, 12);
        Product p2 = new Product(
                "Java for Programmers", 35f, 11);
        Cart c = initializeCart(p, p2);
        System.out.println(c);
        // Oh, I don't need two books
        // on image processing... lets get rid of one.
        c.removeProduct(p);
        System.out.println(c);
    }

    private static Cart initializeCart(Product p,
                                       Product p2) {
        Cart c = new Cart();
        c.addProduct(p);
        c.addProduct(p);
        c.addProduct(p2);
        return c;
    }


}