/*
 * @author Douglas A. Lyon
 * @version  Nov 6, 2002.8:03:04 AM
 */
package xml;


import futils.Futil;
import futils.ReaderUtil;
import graphics.NumImage;
import ip.gui.frames.ImageFrame;
import j2d.ShortImageBean;
import utils.Base64;
import utils.CompactJava;
import xml.adbk.Address;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.awt.*;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.*;


public class Utils {
    static String Address761092 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> " +
            "<java version=\"1.4.2_03\" class=\"java.beans.XMLDecoder\"> " +
            " <object class=\"xml.adbk.Address\"> " +
            "  <void property=\"address1\"> " +
            "   <string>1313 Mocking bird lane</string> " +
            "  </void> " +
            "  <void property=\"city\"> " +
            "   <string>munsterville</string> " +
            "  </void> " +
            "  <void property=\"state\"> " +
            "   <string>ny</string> " +
            "  </void> " +
            "  <void property=\"zip\"> " +
            "   <string>12181</string> " +
            "  </void> " +
            " </object> " +
            "</java>";

    static String ShortImageBean12960684 =
            "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";



    public static void testCodec() {
        testBase64GzipEncoding();
        testBase64GzipDecoding();
    }

    public static void testReadWriteXml() {
        Address a = Address.getSample();
        writeXml(a);
        Object o = readXml();
        System.out.println("read:" + o);
    }

    public static void testXmlImageEncoding() {
        ShortImageBean sib = new ShortImageBean(NumImage.getImage());
        System.out.println(CompactJava.getJava(sib));
    }

    public static String encodeImage(Image img) {
        ShortImageBean sib = new ShortImageBean(img);
        return CompactJava.getCompactJava(sib);
    }

    public static Image decodeImage(String s) {
        Object o = null;
        try {
            o = Base64.decodeToObject(s);
        } catch (Exception e) {

        }
        if (o == null) {
            System.out.println("could not load:" + s);
            return null;
        }
        ShortImageBean sib = (ShortImageBean) o;
        return sib.getImage();
    }

    private static void testBase64GzipDecoding() {
        Object o = Base64.decodeToObject(ShortImageBean12960684);
        ShortImageBean sibTest = (ShortImageBean) o;
        ImageFrame imf = new ImageFrame("sib test");
        imf.setImage(sibTest.getImage());
        imf.setSize(200, 200);
        imf.setVisible(true);
        System.out.println(ShortImageBean12960684);
    }

    public static void testBase64GzipEncodeDecoding() {
        ShortImageBean sib = new ShortImageBean(NumImage.getImage());
        String s =
                Base64.encodeObject(sib,
                        Base64.GZIP | Base64.DONT_BREAK_LINES);
        Object o = Base64.decodeToObject(s);
        ShortImageBean sibTest = (ShortImageBean) o;
        ImageFrame imf = new ImageFrame("sib test");
        imf.setImage(sibTest.getImage());
        imf.setSize(200, 200);
        imf.setVisible(true);
        System.out.println(s);
    }

    private static void testBase64GzipEncoding() {
        ShortImageBean sib = new ShortImageBean(NumImage.getImage());
        System.out.println(CompactJava.getCompactJava(sib));
    }

    public static void testXmlDecoder() {
        Object o = decodeXml(Address761092);
        System.out.println("decode shows:" + o);
        Address a = (Address) o;
        a.toXml();
    }

    public static String getHexString(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        byte b[] = baos.toByteArray();
        StringBuffer sb = new StringBuffer("=\"");

        for (int i = 0; i < b.length; i++) {
            sb.append(Integer.toHexString(b[i]));
            if (i % 16 == 0)
                sb.append("\"+\n\"");
        }
        return sb.toString();
    }

    public static Object readXml() {
        XMLDecoder e =
                new XMLDecoder(
                        Futil.getFileInputStream("select an xml file"));
        return e.readObject();
    }
    public static void main(String[] args) {
        testXmlString();
    }
    public static void testXmlString() {
        final String xmlString = getXmlString("hello world");
        System.out.println("getXmlString="+xmlString);
        System.out.println("after decode we get:"+decodeXml(xmlString));

    }
    public static String getXmlString(Serializable o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(o);
        e.flush();
        return baos.toString() + "</java>";
    }
    public static Object decodeXml(String xml) {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        XMLDecoder d = new XMLDecoder(bais);
        return d.readObject();
    }
    /**
     * write out <code>object</code> as XML.
     *
     * @param object
     */
    public static void writeXml(Serializable object) {
        XMLEncoder e = new XMLEncoder(
                futils.Futil.getFileOutputStream("select xml output file"));
        e.writeObject(object);
        e.close();
    }

    /**
     * getParser returns a SAXParser This was changed to reflect the latest
     * jaxp distro. Since it was subject to deprecation before it is wise
     * to isolate the feature here. This is an example of defensive
     * programming.
     */
    public static SAXParser getParser()
            throws
            org.xml.sax.SAXException,
            ParserConfigurationException {
        // The SAXParserFactory is a a
        // factory class that enables productions
        // of XML parsers:
        SAXParserFactory spf
                = SAXParserFactory.newInstance();

        // setValidating (true) specifies that
        // the parser will validate documents
        // during parsing:

        spf.setValidating(true);
        return spf.newSAXParser();
    }

    public static Object decodeXml(File readFile) {
        String s = ReaderUtil.getFileAsOneBigString(readFile);
        return decodeXml(s);
    }
}
