package video.jsnap;

import futils.Futil;
import gui.ClosableJFrame;
import gui.In;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import j2d.io.gif.neuquantAnimation.NewNeuQuant;

import java.awt.*;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;


public class NqController {

    private NewNeuQuant nq = null;
    private int pixels[] = null;
    private int w = 0;;
    private int h = 0;
    private Image image = null;
    private final MyCanvas canvas = new MyCanvas();


    public NqController(Image img) {
        try {
            set(img);
        } catch (IOException e) {
            In.message(e);

        }
    }

    public void set(Image img) throws IOException {
        initImage(img);
        image = getConvertedImage();
    }

    public Image getConvertedImage() {
        for (int i = 0; i < w * h; i++)
            pixels[i] = nq.convert(pixels[i]);
        return
                canvas.createImage(
                        new MemoryImageSource(w, h, pixels, 0, w));
    }

    private void initImage(Image img) {
        try {
            nq = new NewNeuQuant(img, canvas);
        } catch (IOException e) {
            In.message(e);

        }
        nq.init();
        w = img.getWidth(canvas);
        h = img.getHeight(canvas);
        pixels = new int[w * h];
        java.awt.image.PixelGrabber pg
                = new java.awt.image.PixelGrabber(img,
                        0,
                        0,
                        w,
                        h,
                        pixels,
                        0,
                        w);
        try {
            pg.grabPixels();
        } catch (InterruptedException e) {
        }

    }
    public static ImageProcessorInterface getImageProcessorInterface(){
        return new ImageProcessorInterface(){
            public Image process(Image img){
                NqController nqc = new NqController(img);
                return nqc.getConvertedImage();
            }
        };
    }
    public static Image colorReduce(Image img){
        NqController nqc = new NqController(img);
        return nqc.getConvertedImage();
    }
    public static void main(String[] args) {

        File file = Futil.getReadFile("select an image");
        NqController nqc = new NqController(
                ImageUtils.getImage(file));
        ClosableJFrame frame = new ClosableJFrame("NeuQuant Test");
        frame.setSize(500, 500);
        frame.addComponent(nqc.canvas);
        frame.setVisible(true);


    }

    public Canvas getCanvas() {
        return canvas;
    }

    private class MyCanvas extends Canvas {
        public void paint(Graphics graphics) {
            if (image != null)
                graphics.drawImage(image, 0, 0, this);
            else
                graphics.drawString("image is null",
                        200, 200);
        }
    }
}

