package video.broadcast;

import gui.In;
import j2d.ImageUtils;
import net.multicast.McastUtil;
import net.multicast.Utils;

import java.awt.*;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 25, 2004
 * <p/>
 * Time: 6:24:58 AM
 */
public class BroadcastMain {
    private int port = 2435;
    private McastUtil mcu = new McastUtil(port);

    public static void main(String[] args) {
        new BroadcastMain();
    }

    public  BroadcastMain() {
        mcu.disableLoopBack();
        try {
            new BroadcastViewerThread(mcu);
            if (In.getBoolean("do you want to broadcast?"))
                transmitData();
        } catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void transmitData() throws IOException, AWTException, InterruptedException {
        Rectangle rect = In.getRectangle("select a region to capture");
        for (; ;) {
            final long now = System.currentTimeMillis();
            byte b[] = ImageUtils.grabAPngImage(rect);
            mcu.sendBytes(b);
            long delta = System.currentTimeMillis() - now;
            final long minTime = 250;
            if (delta < minTime)
                Thread.sleep(minTime - delta);
        }
    }

    public void broadcastImages() {
        try {
            broadcastImages(In.getInt("select the number " +
                    "of images to capture"));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * broadcast png images using udp multicast packets.
     *
     * @param n number of images to send.
     * @throws java.io.IOException
     */
    public void broadcastImages(int n) throws IOException {
        final InetAddress inetAddress = Utils.getMcastAddress();
        final int port = 1234;
        final Rectangle rect = In.getRectangle("select a capture area");
        final MulticastSocket mcastSocket =
                Utils.getMulticastSocket(port, inetAddress);
        for (int i = 0; i < n; i++) {
            try {
                sendAnImage(mcastSocket, port, inetAddress, rect, i);
                sleep(1000);
            } catch (IOException e) {
                e.printStackTrace();
            } catch (AWTException e) {
                e.printStackTrace();
            }
        }
        Utils.closeSocket(mcastSocket, inetAddress);
        System.out.println("done xmitting");
    }

    private static void sleep(long i) {
        try {
            Thread.sleep(i);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendAnImage(MulticastSocket mcastSocket, int port,
                             InetAddress inetAddress,
                             Rectangle rect, int i)
            throws IOException, AWTException {
        byte b[] = ImageUtils.grabAPngImage(rect);
        DatagramPacket dp = new DatagramPacket(b,
                b.length,
                inetAddress,
                port);
        mcastSocket.send(dp);
        System.out.println("sent image:" + i);
    }
}
