package utils;

import futils.Futil;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

/**
 * DocJava, Inc. http://www.docjava.com Programmer: dlyon Date: Mar 29,
 * 2004 Time: 3:33:32 PM
 */
public class SystemUtils {
    public static void main(String[] args) {
        System.out.println("getJavaExtensionsDirectory="+ getJavaExtensionsDirectory());
        printProps();

    }
    public static String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public static String getJavaExtensionsDirectory(){
        return System.getProperty("java.ext.dirs");
    }
    public static String getBootPath(){
        return System.getProperty("sun.boot.library.path");
    }
    /**
     * This works on windows and one the mac. It has not been tested on all
     * platforms!
     *
     * @return location of the rmic compiler.
     */
    public static File getRmicPath() {
        // first try the windows location
        String sh = getSdkHome();
        System.out.println("sdkhome=" + getSdkHome());
        String fs = getDirectorySeparator();
        sh = sh +
                fs +
                "bin" +
                fs + "rmic.exe";
        File f = new File(sh);
        if (f.exists()) return f;
        // ok, that did not work..hmm
        // lets try the mac location.
        f = new File(fs + "usr" + fs + "bin" + fs + "rmic");
        if (f.exists()) return f;
        //  OK, now I am stuck, lets ask the user:
        f = Futil.getReadFile("please locate rmic");
        System.out.println(
                "please add:" + f + "to the getRmicPath in SystemUtils");
        return f;
    }

    public static String getSdkHome() {
        String jh = getJavaHome();
        File f = new File(jh);
        return f.getParent();
    }

    public static String getJavaHome() {
        Properties prop = System.getProperties();
        return prop.getProperty("java.home");
    }

    /**
     * @return the location of the program that is running. Typically
     *         something like:<br><code> /User/lyon/current/j4p</code>.
     */
    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    /**
     * @return the character(s) used to delimit directories in path names.
     *         For example:<br> /home/lyon/foo, the file separator is "/".
     */
    public static String getDirectorySeparator() {
        return System.getProperty("file.separator");
    }

    /**
     * @return return the character use to delimit the paths in a list of
     *         paths.
     */
    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static void printProps() {
        System.out.println(getProps());
    }

    public static String getProps() {
        Properties prop = System.getProperties();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        prop.list(ps);
        try {
            baos.close();
        } catch (IOException e) {
        }
        return baos.toString();
    }

    public static void testPrintProps() {
        printProps();
        System.out.println("------------------------");
        System.out.println("os.name=" + OsUtils.getOsName());
        System.out.println("isWindows=" + OsUtils.isWindows());
        System.out.println("free ram=" + free());
        System.out.println("userDir=" + getUserDir());
        System.out.println("userHome=" + getUserHome());
        System.out.println("path sep = " + getPathSeparator());
        System.out.println("file sep = " + getDirectorySeparator());
        System.out.println("getSdkHome=" + getSdkHome());
        System.out.println("getRmicPath=" + getRmicPath());
        System.out.println("getClassPath=" + SystemUtils.getClassPath());

    }

    /**
     * @return a string that describes the JVM's free RAM
     */
    public static String free() {
        futils.Exec e = new futils.Exec();
        return e.getPrintRamString();
    }
    public static void runGc() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        long mem = rt.freeMemory();
        System.out.println("Free Memory = " + mem);
    }

    public static void props() {
        Properties props = System.getProperties();
        for (Enumeration e =
                props.propertyNames(); e.hasMoreElements();) {
            String key = (String) e.nextElement();
            Print.println(key + " = " + props.get(key));
        }
    }

    public static void printProp(String p) {
        System.out.println(p + ":" + System.getProperty(p));
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static void home() {
        printProp("java.home");
    }

    public static void userDir() {
        printProp("user.dir");
    }

    /**
     * Returns the users home directory. For example: <code>C:\Documents
     * and Settings\dlyon</code>
     */
    public static String getUserHome() {
        return System.getProperty("user.home");
    }


    public static String getSysInfo() {
        return (System.getProperty("os.arch") +
                " on " +
                System.getProperty("os.name"));
    }
}

/*
java.runtime.name=Java(TM) 2 Runtime Environment, Stand...
sun.boot.library.path=C:\j2sdk1.4.1_02\jre\bin
java.vm.version=1.4.1_02-b06
java.vm.vendor=Sun Microsystems Inc.
java.vendor.url=http://java.sun.com/
path.separator=;
java.vm.name=Java HotSpot(TM) Client VM
file.encoding.pkg=sun.io
idea.launcher.port=7556
user.country=US
sun.os.patch.level=Service Pack 1
java.vm.specification.name=Java Virtual Machine Specification
user.dir=C:\lyon\j4p
java.runtime.version=1.4.1_02-b06
java.awt.graphicsenv=sun.awt.Win32GraphicsEnvironment
java.endorsed.dirs=C:\j2sdk1.4.1_02\jre\lib\endorsed
os.arch=x86
java.io.tmpdir=C:\DOCUME~1\dlyon\LOCALS~1\Temp\
line.separator=

java.vm.specification.vendor=Sun Microsystems Inc.
user.variant=
os.name=Windows XP
sun.java2d.fontpath=
java.library.path=C:\j2sdk1.4.1_02\bin;.;C:\WINDOWS\Sys...
java.specification.name=Java Platform API Specification
java.class.version=48.0
java.util.prefs.PreferencesFactory=java.util.prefs.WindowsPreferencesFac...
os.version=5.1
user.home=C:\Documents and Settings\dlyon
user.timezone=
java.awt.printerjob=sun.awt.windows.WPrinterJob
file.encoding=windows-1252
java.specification.version=1.4
user.name=dlyon
java.class.path=C:\j2sdk1.4.1_02\jre\lib\charsets.jar...
java.vm.specification.version=1.0
sun.arch.data.model=32
java.home=C:\j2sdk1.4.1_02\jre
java.specification.vendor=Sun Microsystems Inc.
user.language=en
awt.toolkit=sun.awt.windows.WToolkit
java.vm.info=mixed mode
java.version=1.4.1_02
java.ext.dirs=C:\j2sdk1.4.1_02\jre\lib\ext
sun.boot.class.path=C:\j2sdk1.4.1_02\jre\lib\rt.jar;C:\j2...
java.vendor=Sun Microsystems Inc.
file.separator=\
java.vendor.url.bug=http://java.sun.com/cgi-bin/bugreport...
idea.launcher.library=C:\IntelliJ-IDEA-4.0\bin\breakgen.dll
sun.cpu.endian=little
sun.io.unicode.encoding=UnicodeLittle
sun.cpu.isalist=pentium i486 i386
*/
