package utils;

import java.util.StringTokenizer;

/**
 * Copyright DocJava, inc. User: lyon Date: Sep 6,
 * 2004 Time: 8:35:04 AM
 */
public class StringUtils {
    public static char NEW_LINE = 0x0A;
    public static String NEW_LINE_STRING = ""+0x0A;


    public static StringBuffer LowerCaseFirstLetter(
            String s) {
        StringBuffer sb = new StringBuffer(s);
        char c = sb.charAt(0);
        sb.setCharAt(0,Character.toLowerCase(c));
        return sb;
    }
    /**
     * Replace all instances of the oldChar with the
     * newChar and create a new string;
     * @param s  the old string is unchanged
     * @param oldChar the old char to search for
     * @param newChar  the new char to replace it with
     * @return  a new string that is the same size as the old string
     */
    public static String replaceChar(String s,char oldChar,char newChar){
        char ca[] = s.toCharArray();
        for (int i=0; i < ca.length;i++){
            if (ca[i]==oldChar) ca[i] = newChar;
        }
        return new String(ca);
    }

    public static String removeChar(String s, char oldChar) {
       return StringUtils.replaceAll(s,oldChar+"","");
    }

    public static String sub(String line,
                             String stringToEliminate,
                             String replacementString) {
        int ssSize = stringToEliminate.length();
        int i = line.indexOf(stringToEliminate);
        if (i < 0) return line;
        return line.substring(0, i) +
               replacementString
               + line.substring(i + ssSize);
    }

    public static String replaceFirstInstance(
            String inputString,
            String searchString,
            String replacementString) {
        int i = inputString.indexOf(searchString);
        if (i == -1) return inputString;
        int ssSize = searchString.length();
        String part1 = inputString.substring(0,
                                             i);
        String part2 = inputString.substring(
                i + ssSize);
        return part1 + replacementString + part2;
    }

    /**
     * replaceAll
     *
     * @param s             input String
     * @param searchString  The string to searchFor
     * @param replaceString The string to replace
     *                      it with
     * @return new string
     */
    public static String replaceAll(String s,
                                    String searchString,
                                    String replaceString) {
        int i = s.indexOf(searchString);
        if (i == -1) return s;
        int ssSize = searchString.length();
        while (i != -1) {
            String part1 = s.substring(0, i);
            String part2 = s.substring(
                    i + ssSize);
            s = part1 + replaceString + part2;
            i = s.indexOf(searchString,
                          i +
                          replaceString.length());
        }
        return s;
    }

    public static void main(String args[]) {
        final String testString = "new\nline";
        hexDump(testString);
        hexDump(replaceChar(testString, '\n', '#'));
    }
    public static void hexDump(String s){
        char c[] =  s.toCharArray();
        for (int i=0; i < c.length; i++){
            System.out.println(Integer.toHexString(c[i])+'\t'+c[i]+'\n');

        }
    }
    /**
     * Replace all occurances of the searchString
     * in the inputString with the replaceString
     * @param inputString left unmolested
     * @param searchString an array of strings to search for
     * @param replaceString  the new string to replace them with
     * @return a new string  a brand new string
     */
    public static String replaceAll(String inputString,
                                    String searchString[],
                                    String replaceString) {
        for (int i = 0; i < searchString.length; i++)
            inputString = replaceAll(inputString, searchString[i], replaceString);
        return inputString;
    }

    public static void testBug() {
        String s = "c:\\test";
        s = replaceAll(s, "\\", "/");
        System.out.println(s);
    }

    public static void testReplace() {
        String ss[] = {"if", "then", "static"};
        String s = "public static public static if if then static";
        s = replaceAll(s, ss, "");
        System.out.println(s);
    }

    /**
     * Determine how many tokens are in a string
     *
     * @param l The string to be processed
     * @return the number of tokens
     */
    public static int addTokens(String l) {
        System.out.println(l);
        int sum = 0;
        StringTokenizer st
                = new StringTokenizer(l,
                                      ", \t\r\f\n\"\\;");
        int tc = st.countTokens();
        System.out.println("tc=" + tc);
        for (int i = 0; i < tc; i++) {
            String s = st.nextToken();
            int j = 0;
            try {
                j = Integer.parseInt(s);
            } catch (NumberFormatException e) {

            }
            System.out.println(j);
            sum = sum + j;
        }
        return sum;
    }

    /**
     * Method replaceAll.
     *
     * @return String
     */
    public static String replaceAllSb(String s, String orig, String dest) {
        StringBuffer sb = new StringBuffer();
        int pos = 0, lastpos;
        do {
            lastpos = pos;
            pos = s.indexOf(orig, pos);
            if (pos == -1) continue;
            sb.append(s.substring(lastpos, pos));
            sb.append(dest);
            pos += orig.length();
        } while (pos != -1);
        sb.append(s.substring(lastpos));
        return sb.toString();
    }

    public static char getFirstChar(String s) {
        char ca[] = s.toCharArray();
        return ca[0];
    }

    public static int getNumberOfDigits(String s) {
        char c[] = s.toCharArray();
        int nod = 0;
        for (int i=0; i < c.length; i++)
          if (Character.isDigit(c[i])) nod++;
        return nod;
    }
}
