package utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.prefs.Preferences;


public class IO {
  public static void show(Object s) {
    javax.swing.JOptionPane.showMessageDialog(null, s);
  }

  public static String getString(Object o) {
    return javax.swing.JOptionPane.showInputDialog(o);
  }

  public static int getInt(Object o) {
    String s = getString(o);
    try {
      return Integer.parseInt(s);
    } catch (NumberFormatException e) {
      return getInt(s + " is not an int!" + o);
    }
  }

  public static double getDouble(Object o) {
    String s = getString(o);
    try {
      Double d = Double.valueOf(s);
      return d.doubleValue();
    } catch (NumberFormatException e) {
      return getDouble(s + " is not a double!" + o);
    }
  }

  public static void main(String args[]) {
    show(
        "Hello " +
        getString("Please Enter your name:"));
    show("age=" +
         getInt("Enter your age:"));
  }

    public static void save(Serializable s, String key) throws IOException {
        Preferences p = Preferences.userRoot();
        ByteArrayOutputStream baos = new
                ByteArrayOutputStream();
        ObjectOutputStream oos = new
                ObjectOutputStream(baos);
        oos.writeObject(s);
        baos.close();
        p.putByteArray(key, baos.toByteArray());
    }

   
}