package sound.soundDemo;

// sound.soundDemo.JavaSound

/*
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioSystem;
import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

/**
 *
 * @author Brian Lichtenwalter
 * @version @(#)JavaSound.java	1.17 02/02/06
 */
public class CapturePlaybackHack  {
    JTabbedPane tabPane = new JTabbedPane();
    int width = 760, height = 500;
    int index;
    private final MyJPanel jPanel = new MyJPanel();

    public CapturePlaybackHack(String audioDirectory) {
        jPanel.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        if (JavaSoundApplet.applet == null) {
            JMenu fileMenu = (JMenu) menuBar.add(new JMenu("File"));
        }
        JPanel p = getCapturePlaybackPanel();
        tabPane.addTab("Capture/Playback", p);
        jPanel.add(tabPane, BorderLayout.CENTER);
    }

    public JPanel getCapturePlaybackPanel() {
        JPanel p = new JPanel(new BorderLayout());
        CapturePlaybackPanel capturePlaybackPanel = new CapturePlaybackPanel();
        p.add(capturePlaybackPanel);
        return p;
    }

    public static void main(String[] args) {
        checkAudio();
        String media = "media";
        if (args.length > 0) {
            File file = new File(args[0]);
            if (file == null && !file.isDirectory()) {
                System.out.println("usage: java JavaSound audioDirectory");
            } else {
                media = args[0];
            }
        }
        final CapturePlaybackHack demo = new CapturePlaybackHack(media);
        JFrame f = new JFrame("Java Sound Demo");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }
        });
        f.getContentPane().add("Center", demo.jPanel);
        f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation(d.width / 2 - demo.width / 2, d.height / 2 - demo.height / 2);
        f.setSize(new Dimension(demo.width, demo.height));
        f.setVisible(true);
    }

    private static void checkAudio() {
        try {
            if (MidiSystem.getSequencer() == null) {
                System.err.println("MidiSystem Sequencer Unavailable, exiting!");
                System.exit(1);
            } else if (AudioSystem.getMixer(null) == null) {
                System.err.println("AudioSystem Unavailable, exiting!");
                System.exit(1);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private class MyJPanel extends JPanel {
        public Dimension getPreferredSize() {
            return new Dimension(CapturePlaybackHack.this.width, CapturePlaybackHack.this.height);
        }
    }
}
