/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package sound.player;

/**
 * Created by IntelliJ IDEA.
 * User: Douglas Lyon
 * Date: Dec 13, 2004
 * Time: 8:09:16 PM
 * Copyright DocJava, Inc.
 */

import gui.In;

import javax.sound.sampled.*;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Synth {

    //The following are general instance variables
    // used to create a SourceDataLine object.
    AudioFormat audioFormat;
    AudioInputStream audioInputStream;
    SourceDataLine sourceDataLine;

    //The following are audio format parameters.
    // They may be modified by the signal generator
    // at runtime.  Values allowed by Java
    // SDK 1.4.1 are shown in comments.
    float sampleRate = 16000.0F;
    //Allowable 8000,11025,16000,22050,44100
    int sampleSizeInBits = 16;
    //Allowable 8,16
    int channels = 1;
    //Allowable 1,2
    boolean signed = true;
    //Allowable true,false
    boolean bigEndian = true;
    //Allowable true,false

    //A buffer to hold two seconds monaural and one
    // second stereo data at 16000 samp/sec for
    // 16-bit samples
    byte audioData[] = new byte[16000 * 4];


    public Synth() {//constructor


    }//end constructor
    //-------------------------------------------//

    //This method plays or files the synthetic
    // audio data that has been generated and saved
    // in an array in memory.
    public void playOrFileData() throws LineUnavailableException {
        //Get an input stream on the byte array
        // containing the data
        InputStream byteArrayInputStream =
                new ByteArrayInputStream(audioData);

        //Get the required audio format
        audioFormat = new AudioFormat(
                sampleRate,
                sampleSizeInBits,
                channels,
                signed,
                bigEndian);

        //Get an audio input stream from the
        // ByteArrayInputStream
        audioInputStream = new AudioInputStream(
                byteArrayInputStream,
                audioFormat,
                audioData.length / audioFormat.
                getFrameSize());

        //Get info on the required data line
        DataLine.Info dataLineInfo =
                new DataLine.Info(
                        SourceDataLine.class,
                        audioFormat);

        //Get a SourceDataLine object
        sourceDataLine = (SourceDataLine)
                AudioSystem.getLine(dataLineInfo);


    }//end playOrFileData

    public void startToListen(Generator g) {
        g.getSyntheticData(audioData);
        new ListenThread().start();
    }
//=============================================//

//Inner class to play back the data that was
// saved.
    class ListenThread extends Thread {
        //This is a working buffer used to transfer
        // the data between the AudioInputStream and
        // the SourceDataLine.  The size is rather
        // arbitrary.
        byte playBuffer[] = new byte[16384];

        public void run() {
            try {


                //Open and start the SourceDataLine
                sourceDataLine.open(audioFormat);
                sourceDataLine.start();

                int cnt;
                //Get beginning of elapsed time for

                //Transfer the audio data to the speakers
                while ((
                        cnt = audioInputStream.read(
                                playBuffer, 0,
                                playBuffer.length))
                        != -1) {
                    //Keep looping until the input read
                    // method returns -1 for empty stream.
                    if (cnt > 0) {
                        //Write data to the internal buffer of
                        // the data line where it will be
                        // delivered to the speakers in real
                        // time
                        sourceDataLine.write(playBuffer, 0, cnt);
                    }//end if
                }//end while

                //Block and wait for internal buffer of the
                // SourceDataLine to become empty.
                sourceDataLine.drain();




                //Finish with the SourceDataLine
                sourceDataLine.stop();
                sourceDataLine.close();


            } catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }//end catch

        }//end run
    }//end inner class ListenThread
    public static void main(String[] args) {
        Synth s = new Synth();
        Generator g = new Generator(s);
        g.tones();
        try {
            s.playOrFileData();
        } catch (LineUnavailableException e) {
            In.message(e);

        }
    }
    //todo this is buggy

}