package sound.musica;

import sound.Utils;

/*
 * Open Source Software by http://www.Docjava.com
 * programmer: D. Lyon
 * e-mail: lyon@docjava.com
 * Date: Apr 29, 2002
 * Time: 12:39:06 PM
 */

public class Scales2 {
    public static int CHROMATIC[] = {
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

    };
    public static int WHOLE_NOTES[] = {//major scale
        0, 2, 2, 1, 2, 2, 2, 1, 1
        // doe, re, me, fa, sol, la, ti, doe
        // 0,1,2,3,4,5,6,7,8,9,10,11
        // c, c#, D, D#, E, F, F#, G, G#, A, A#, B
        //whole notes are
        // C, D, E, F, G, A, B
        // 0, 2,4,5,7,9,11 <- note number
        // 0, 2,2,1,2,2,2
    };
    public static int occidentals[] = {//sharps and flats
        1, 2, 3, 2, 2, 3
    };
    public static int SILLY_SCALE[] = {
        1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 3,
        1, 1, 4, 1, 1, 4, 1, 1, 4, 1, 1, 4,
        1, 1, 5, 1, 1, 5, 1, 1, 5, 1, 1, 5

    };
    protected static int IONIAN[] = {
        2, 2, 1, 2, 2, 2, 1
    };
    public static int HARMONIC_MINOR[] = {
        2, 1, 2, 2, 1, 3, 1
    };
    protected static int GYPSY[] = {
        1, 3, 1, 1, 2, 1, 3, 1
    };

    public static void testWholeNotes() {
        int speed = 500;
        System.out.println("occidentals");
        int[] scale = getScale(occidentals, 30);
        sound.Utils.play(scale, speed);
        Utils.print(scale);
    }

    public static void testPlayScale() {
        int speed = 50;
        System.out.println("SILLY_SCALE");
        Utils.play(getScale(SILLY_SCALE, 35), speed);

        System.out.println("gypsy");

        Utils.play(getScale(GYPSY, 35), speed);
        System.out.println("CHROMATIC");
        Utils.play(getScale(CHROMATIC, 35), speed);
        System.out.println("HARMONIC_MINOR");
        Utils.play(getScale(HARMONIC_MINOR, 32), speed);
    }

    public static void main(String args[]) {
        testWholeNotes();
    }

    /**
     * get a scale starting at any note,
     * in a given progression.
     * The scale is as long as the progression.
     * for example:
     * 0,2,2,1,2,2,1, starting at 10 gives
     * 10,12,14,15,17,19,20
     */
    public static int[] getScale(
            int progression[], int startNote) {
        //0,2, 2, 1, 2, 2, 2,1
        int scale[] = new int[progression.length];
        for (int i = 0; i < progression.length; i++) {
            int octaveNumber = i / progression.length;
            scale[i] = startNote + progression[i % progression.length];
            startNote = scale[i] * octaveNumber;
        }
        return scale;
    }

    /**
     * start a prgression at any note and end and any note
     */
    public static int[] getScale(
            int progression[], int startNote, int endNote) {
        int scale[] = new int[endNote - startNote];
        for (int i = 0; i < scale.length; i++) {
            scale[i] = startNote + progression[i % progression.length];
            startNote = scale[i % scale.length];
        }
        return scale;
    }
}
