package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SPlaneBean.java

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class SPlaneBean extends Canvas
        implements Serializable,
                   MouseListener,
                   MouseMotionListener,
                   ActionListener,
                   BodeListener,
                   AutoscaleListener {

    public SPlaneBean() {
        poleColor = Color.red;
        zeroColor = Color.blue;
        crossColor = Color.green;
        bodeListeners = new Vector();
        myMouseListeners = new Vector();
        pcs = new PropertyChangeSupport(this);
        hs = new HsFrame();
        hs3D = new Hs3DFrame();
        sFrame = new SPlaneFrame(this);
        editRoot = new EditRootFrame(this);
        poles = new Vector();
        zeros = new Vector();
        inside = false;
        newRoot = null;
        isZero = true;
        selectedRoot = false;
        delRoot = false;
        multi = false;
        Height = Width = 20;
        xMax = yMax = 2D;
        rootNumber = -1;
        thickness = 1;
        pop = new PopupMenu("Choose action");
        m1 = new MenuItem("Add a pole");
        pop.add(m1);
        m2 = new MenuItem("Add a zero");
        pop.add(m2);
        pop.add("-");
        m3 = new MenuItem("Add multiple pole");
        pop.add(m3);
        m4 = new MenuItem("Add multiple zero");
        pop.add(m4);
        pop.add("-");
        m5 = new MenuItem("Delete pole/zero");
        pop.add(m5);
        m6 = new MenuItem("No operation");
        pop.add(m6);
        m7 = new MenuItem("Clear'em all");
        pop.add(m7);
        pop.add("-");
        m8 = new MenuItem("Rescale");
        pop.add(m8);
        m9 = new Menu("Zoom");
        m9_1 = new MenuItem("1/5");
        m9.add(m9_1);
        m9_2 = new MenuItem("1/2");
        m9.add(m9_2);
        m9_3 = new MenuItem(" 2 ");
        m9.add(m9_3);
        m9_4 = new MenuItem(" 5 ");
        m9.add(m9_4);
        m9_5 = new MenuItem(" 10 ");
        m9.add(m9_5);
        pop.add(m9);
        pop.add("-");
        m10 = new MenuItem("Show |H(s)|");
        pop.add(m10);
        m12 = new MenuItem("Show |H(s)|-3D");
        pop.add(m12);
        m11 = new MenuItem("Set Parameters");
        pop.add(m11);
        add(pop);
        setBackground(Color.white);
        setForeground(Color.black);
        setFont(new Font("Dialog", 0, 12));
        setCursor(new Cursor(1));
        addMouseListener(this);
        addMouseMotionListener(this);
        m1.addActionListener(this);
        m2.addActionListener(this);
        m3.addActionListener(this);
        m4.addActionListener(this);
        m5.addActionListener(this);
        m6.addActionListener(this);
        m7.addActionListener(this);
        m8.addActionListener(this);
        m9_1.addActionListener(this);
        m9_2.addActionListener(this);
        m9_3.addActionListener(this);
        m9_4.addActionListener(this);
        m9_5.addActionListener(this);
        m10.addActionListener(this);
        m11.addActionListener(this);
        m12.addActionListener(this);
    }

    public synchronized void paint(Graphics g) {
        update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension dimension = getSize();
        if (offGraphics == null ||
                dimension.width != offDimension.width ||
                dimension.height != offDimension.height) {
            offDimension = dimension;
            offImage = createImage(dimension.width, dimension.height);
            offGraphics = offImage.getGraphics();
        }
        offGraphics.setColor(getBackground());
        offGraphics.fillRect(0,
                0,
                offDimension.width,
                offDimension.height);
        Width = getSize().width;
        Height = getSize().height;
        if (inside) {
            offGraphics.setColor(crossColor);
            offGraphics.drawLine(1, cursorY, Width - 2, cursorY);
            offGraphics.drawLine(cursorX, 1, cursorX, Height - 2);
        }
        drawPoleAndZero(offGraphics);
        offGraphics.setColor(getForeground());
        if (newRoot != null)
            newRoot.draw(offGraphics, xMax, yMax, Width, Height);
        offGraphics.setColor(getForeground());
        offGraphics.drawLine(0, Height / 2, Width, Height / 2);
        offGraphics.drawLine(Width / 2, 0, Width / 2, Height);
        offGraphics.drawRect(0, 0, Width - 1, Height - 1);
        offGraphics.drawLine(Width / 2 - 5,
                Height / 4,
                Width / 2 + 5,
                Height / 4);
        offGraphics.drawString(d2str(yMax / 2D, 0),
                Width / 2 + 9,
                Height / 4 + 8);
        offGraphics.drawLine(Width / 2 - 5,
                (3 * Height) / 4,
                Width / 2 + 5,
                (3 * Height) / 4);
        offGraphics.drawString(d2str(-yMax / 2D, 0),
                Width / 2 + 5,
                (3 * Height) / 4 + 8);
        offGraphics.drawLine(Width / 4,
                Height / 2 - 5,
                Width / 4,
                Height / 2 + 5);
        offGraphics.drawString(d2str(-xMax / 2D, 0),
                Width / 4 - 12,
                Height / 2 + 16);
        offGraphics.drawLine((3 * Width) / 4,
                Height / 2 - 5,
                (3 * Width) / 4,
                Height / 2 + 5);
        offGraphics.drawString(d2str(xMax / 2D, 0),
                (3 * Width) / 4 - 8,
                Height / 2 + 16);
        g.drawImage(offImage, 0, 0, this);
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == m1) {
            newPole();
            return;
        }
        if (obj == m2) {
            newZero();
            return;
        }
        if (obj == m3) {
            newMultiPole();
            return;
        }
        if (obj == m4) {
            newMultiZero();
            return;
        }
        if (obj == m5) {
            delRoot();
            return;
        }
        if (obj == m6) {
            noop();
            return;
        }
        if (obj == m7) {
            clear();
            return;
        }
        if (obj == m8) {
            rescale(2D);
            return;
        }
        if (obj == m9_1) {
            xMax /= 5D;
            yMax /= 5D;
            repaint();
            return;
        }
        if (obj == m9_2) {
            xMax /= 2D;
            yMax /= 2D;
            repaint();
            return;
        }
        if (obj == m9_3) {
            xMax *= 2D;
            yMax *= 2D;
            repaint();
            return;
        }
        if (obj == m9_4) {
            xMax *= 5D;
            yMax *= 5D;
            repaint();
            return;
        }
        if (obj == m9_5) {
            xMax *= 10D;
            yMax *= 10D;
            repaint();
            return;
        }
        if (obj == m10) {
            hs.wake(zeros, poles, getSize(), xMax, yMax);
            return;
        }
        if (obj == m11) {
            sFrame.wake();
            return;
        }
        if (obj == m12)
            hs3D.wake(zeros, poles, xMax, yMax);
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 4) == 4 ||
                mouseevent.isShiftDown())
            pop.show(this, mouseevent.getX(), mouseevent.getY());
        else if (newRoot != null) {
            if (isZero)
                zeros.addElement(newRoot);
            else
                poles.addElement(newRoot);
            fireBodeEvent(
                    new BodeEvent(this,
                            newRoot,
                            isZero ? 1 : 0,
                            rootNumber));
            if (multi) {
                if (isZero)
                    newRoot = new Zero();
                else
                    newRoot = new Pole();
                newRoot.setPos(
                        ((double) ((mouseevent.getX() - Width / 2) * 2) *
                        xMax) /
                        (double) Width,
                        ((double) ((Height / 2 - mouseevent.getY()) * 2) *
                        yMax) /
                        (double) Height);
            } else {
                newRoot = null;
            }
            repaint();
        }
        rootNumber = -1;
        if (!selectedRoot && newRoot == null) {
            int i = mouseevent.getX();
            int j = mouseevent.getY();
            int k = poles.size() - 1;
            int l = zeros.size() - 1;
            for (; !selectedRoot && k > -1; k--)
                if (((Pole) poles.elementAt(k)).inRoot(xMax,
                        yMax,
                        Width,
                        Height,
                        i,
                        j)) {
                    selectedRoot = true;
                    isZero = false;
                    rootNumber = k;
                }

            for (; !selectedRoot && l > -1; l--)
                if (((Zero) zeros.elementAt(l)).inRoot(xMax,
                        yMax,
                        Width,
                        Height,
                        i,
                        j)) {
                    selectedRoot = true;
                    isZero = true;
                    rootNumber = l;
                }

        }
        if (selectedRoot && mouseevent.getClickCount() == 2)
            if (isZero)
                editRoot.wake(rootNumber,
                        isZero,
                        (Root) zeros.elementAt(rootNumber));
            else
                editRoot.wake(rootNumber,
                        isZero,
                        (Root) poles.elementAt(rootNumber));
        if (delRoot && rootNumber != -1) {
            if (isZero) {
                Root root = null;
                zeros.removeElementAt(rootNumber);
                fireBodeEvent(new BodeEvent(this, root, 5, rootNumber));
                delRoot = false;
            } else {
                Root root1 = null;
                poles.removeElementAt(rootNumber);
                fireBodeEvent(new BodeEvent(this, root1, 4, rootNumber));
                delRoot = false;
            }
            selectedRoot = false;
            repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if (selectedRoot) {
            double d;
            double d1;
            if (isZero) {
                d = ((Zero) zeros.elementAt(rootNumber)).getReal();
                d1 = ((Zero) zeros.elementAt(rootNumber)).getImag();
            } else {
                d = ((Pole) poles.elementAt(rootNumber)).getReal();
                d1 = ((Pole) poles.elementAt(rootNumber)).getImag();
            }
            if (Math.abs(d) > xMax)
                xMax = Math.abs(d);
            if (Math.abs(d1) > yMax)
                yMax = Math.abs(d1);
            repaint();
        }
        selectedRoot = false;
    }

    public void mouseEntered(MouseEvent mouseevent) {
        inside = true;
    }

    public void mouseExited(MouseEvent mouseevent) {
        inside = false;
        fireMyMouseEvent(new MyMouseEvent(this, "SPlane", 0.0D, 0.0D));
        repaint();
    }

    public void mouseMoved(MouseEvent mouseevent) {
        cursorX = mouseevent.getX();
        cursorY = mouseevent.getY();
        if (newRoot != null)
            newRoot.setPos(
                    ((double) ((cursorX - Width / 2) * 2) * xMax) /
                    (double) Width,
                    ((double) ((Height / 2 - cursorY) * 2) * yMax) /
                    (double) Height);
        repaint();
        fireMyMouseEvent(
                new MyMouseEvent(this,
                        "SPlane",
                        ((double) ((cursorX - Width / 2) * 2) * xMax) /
                (double) Width,
                        ((double) ((Height / 2 - cursorY) * 2) * yMax) /
                (double) Height));
    }

    public void mouseDragged(MouseEvent mouseevent) {
        cursorX = mouseevent.getX();
        cursorY = mouseevent.getY();
        if (selectedRoot)
            if (isZero) {
                ((Zero) zeros.elementAt(rootNumber)).setPos(
                        ((double) ((cursorX - Width / 2) * 2) * xMax) /
                        (double) Width,
                        ((double) ((Height / 2 - cursorY) * 2) * yMax) /
                        (double) Height);
                fireBodeEvent(
                        new BodeEvent(this,
                                (Root) zeros.elementAt(rootNumber),
                                3,
                                rootNumber));
            } else {
                ((Pole) poles.elementAt(rootNumber)).setPos(
                        ((double) ((cursorX - Width / 2) * 2) * xMax) /
                        (double) Width,
                        ((double) ((Height / 2 - cursorY) * 2) * yMax) /
                        (double) Height);
                fireBodeEvent(
                        new BodeEvent(this,
                                (Root) poles.elementAt(rootNumber),
                                2,
                                rootNumber));
            }
        repaint();
        fireMyMouseEvent(
                new MyMouseEvent(this,
                        "SPlane",
                        ((double) ((cursorX - Width / 2) * 2) * xMax) /
                (double) Width,
                        ((double) ((Height / 2 - cursorY) * 2) * yMax) /
                (double) Height));
    }

    public void changeOccured(BodeEvent bodeevent) {
        if (bodeevent.getSource() != this) {
            switch (bodeevent.getType()) {
                default:
                    break;

                case 0: // '\0'
                    poles.addElement(new Pole((Pole) bodeevent.getRoot()));
                    break;

                case 1: // '\001'
                    zeros.addElement(new Zero((Zero) bodeevent.getRoot()));
                    break;

                case 2: // '\002'
                    ((Pole) poles.elementAt(bodeevent.getPosition())).setPos(
                            bodeevent.getRoot().getReal(),
                            bodeevent.getRoot().getImag());
                    break;

                case 3: // '\003'
                    ((Zero) zeros.elementAt(bodeevent.getPosition())).setPos(
                            bodeevent.getRoot().getReal(),
                            bodeevent.getRoot().getImag());
                    break;

                case 4: // '\004'
                    poles.removeElementAt(bodeevent.getPosition());
                    break;

                case 5: // '\005'
                    zeros.removeElementAt(bodeevent.getPosition());
                    break;

                case 6: // '\006'
                    zeros.removeAllElements();
                    poles.removeAllElements();
                    break;

                case 7: // '\007'
                    Vector vector = bodeevent.getPoles();
                    synchronized (this) {
                        if (vector != null) {
                            poles.removeAllElements();
                            for (int i = 0; i < vector.size(); i++)
                                poles.addElement(
                                        new Pole(
                                                (Pole) vector.elementAt(i)));

                        }
                    }
                    break;

                case 8: // '\b'
                    Vector vector1 = bodeevent.getZeros();
                    synchronized (this) {
                        if (vector1 != null) {
                            zeros.removeAllElements();
                            for (int j = 0; j < vector1.size(); j++)
                                zeros.addElement(
                                        new Zero(
                                                (Zero) vector1.elementAt(
                                                        j)));

                        }
                    }
                    break;

                case 9: // '\t'
                    Vector vector2 = bodeevent.getPoles();
                    Vector vector3 = bodeevent.getZeros();
                    synchronized (this) {
                        if (vector2 != null) {
                            poles.removeAllElements();
                            for (int k = 0; k < vector2.size(); k++)
                                poles.addElement(
                                        new Pole(
                                                (Pole) vector2.elementAt(
                                                        k)));

                        }
                        if (vector3 != null) {
                            zeros.removeAllElements();
                            for (int l = 0; l < vector3.size(); l++)
                                zeros.addElement(
                                        new Zero(
                                                (Zero) vector3.elementAt(
                                                        l)));

                        }
                    }
                    break;
            }
            repaint();
        }
    }

    public synchronized void autoscaleOccured(
            AutoscaleEvent autoscaleevent) {
        rescale(autoscaleevent.factor);
    }

    public synchronized void drawPoleAndZero(Graphics g) {
        g.setColor(poleColor);
        for (int i = 0; i < poles.size(); i++)
            ((Root) poles.elementAt(i)).draw(g,
                    xMax,
                    yMax,
                    Width,
                    Height);

        g.setColor(zeroColor);
        for (int j = 0; j < zeros.size(); j++)
            ((Root) zeros.elementAt(j)).draw(g,
                    xMax,
                    yMax,
                    Width,
                    Height);

    }

    public synchronized void changeRoot(int i,
                                        boolean flag,
                                        double d,
                                        double d1) {
        if (flag) {
            ((Zero) zeros.elementAt(i)).setPos(d, d1);
            fireBodeEvent(
                    new BodeEvent(this, (Root) zeros.elementAt(i), 3, i));
        } else {
            ((Pole) poles.elementAt(i)).setPos(d, d1);
            fireBodeEvent(
                    new BodeEvent(this, (Root) poles.elementAt(i), 2, i));
        }
        repaint();
    }

    public synchronized void newPole() {
        newRoot = new Pole();
        isZero = false;
        delRoot = false;
        multi = false;
    }

    public synchronized void newZero() {
        newRoot = new Zero();
        isZero = true;
        delRoot = false;
        multi = false;
    }

    public synchronized void newMultiPole() {
        newRoot = new Pole();
        isZero = false;
        delRoot = false;
        multi = true;
    }

    public synchronized void newMultiZero() {
        newRoot = new Zero();
        isZero = true;
        delRoot = false;
        multi = true;
    }

    public synchronized void delRoot() {
        newRoot = null;
        delRoot = true;
    }

    public synchronized void noop() {
        newRoot = null;
        delRoot = false;
        repaint();
    }

    public synchronized void clear() {
        fireBodeEvent(new BodeEvent(this));
        newRoot = null;
        delRoot = false;
        rootNumber = 0;
        poles.removeAllElements();
        zeros.removeAllElements();
        repaint();
    }

    public synchronized void rescale(double d) {
        boolean flag = false;
        if (d == 0.0D)
            d = 2D;
        if (poles.size() != 0) {
            xMax = d * Math.abs(((Pole) poles.elementAt(0)).getReal());
            yMax = d * Math.abs(((Pole) poles.elementAt(0)).getImag());
            for (int i = 1; i < poles.size(); i++) {
                Pole pole = (Pole) poles.elementAt(i);
                if (Math.abs(d * pole.getReal()) > xMax)
                    xMax = d * Math.abs(pole.getReal());
                if (Math.abs(d * pole.getImag()) > yMax)
                    yMax = d * Math.abs(pole.getImag());
            }

            flag = true;
        } else {
            xMax = yMax = 2D;
        }
        if (zeros.size() != 0) {
            boolean flag1 = false;
            if (!flag) {
                xMax = d * Math.abs(((Zero) zeros.elementAt(0)).getReal());
                yMax = d * Math.abs(((Zero) zeros.elementAt(0)).getImag());
                flag1 = true;
            }
            for (int j = ((flag1) ? 1 : 0); j < zeros.size(); j++) {
                Zero zero = (Zero) zeros.elementAt(j);
                if (Math.abs(d * zero.getReal()) > xMax)
                    xMax = d * Math.abs(zero.getReal());
                if (Math.abs(d * zero.getImag()) > yMax)
                    yMax = d * Math.abs(zero.getImag());
            }

        }
        if (xMax == 0.0D)
            xMax = 1.0D;
        if (yMax == 0.0D)
            yMax = 1.0D;
    }

    public void setXAxis(double d) {
        xMax = Math.abs(d);
        repaint();
    }

    public void setYAxis(double d) {
        yMax = Math.abs(d);
        repaint();
    }

    public String d2str(double d, int i) {
        int j = 0xa ^ i;
        return Double.toString(Math.rint(d * (double) j) / (double) j);
    }

    public void changeRootPos(double d, double d1) {
        if (isZero)
            ((Zero) zeros.elementAt(rootNumber)).setPos(d, d1);
        else
            ((Pole) poles.elementAt(rootNumber)).setPos(d, d1);
        if (Math.abs(d) > xMax)
            xMax = Math.abs(d);
        if (Math.abs(d1) > yMax)
            yMax = Math.abs(d1);
        repaint();
    }

    public void newParams(Vector vector) {
        params = vector;
        xMax = ((Double) params.elementAt(0)).doubleValue();
        yMax = ((Double) params.elementAt(1)).doubleValue();
        thickness = ((Integer) params.elementAt(2)).intValue();
        repaint();
    }

    public Vector oldParams() {
        params = new Vector();
        params.addElement(new Double(xMax));
        params.addElement(new Double(yMax));
        return params;
    }

    public synchronized void addMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.addElement(mymouselistener);
    }

    public synchronized void removeMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.removeElement(mymouselistener);
    }

    public void fireMyMouseEvent(MyMouseEvent mymouseevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) myMouseListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            MyMouseListener mymouselistener = (MyMouseListener) vector.elementAt(
                    i);
            mymouselistener.mouseOccured(mymouseevent);
        }

    }

    public synchronized void addBodeListener(BodeListener bodelistener) {
        bodeListeners.addElement(bodelistener);
    }

    public synchronized void removeBodeListener(BodeListener bodelistener) {
        bodeListeners.removeElement(bodelistener);
    }

    public void fireBodeEvent(BodeEvent bodeevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) bodeListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            BodeListener bodelistener = (BodeListener) vector.elementAt(i);
            bodelistener.changeOccured(bodeevent);
        }

    }

    public void addPropertyChangeListener(
            PropertyChangeListener propertychangelistener) {
        pcs.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(
            PropertyChangeListener propertychangelistener) {
        pcs.removePropertyChangeListener(propertychangelistener);
    }

    public void setFontSize(int i) {
        Font font = getFont();
        setFont(new Font(font.getName(), font.getStyle(), i));
        pcs.firePropertyChange("fontSize",
                new Integer(font.getSize()),
                new Integer(i));
    }

    public void setFont(Font font) {
        Font font1 = getFont();
        super.setFont(font);
        pcs.firePropertyChange("font", font1, font);
    }

    public void setBackground(Color color) {
        Color color1 = getBackground();
        super.setBackground(color);
        pcs.firePropertyChange("background", color1, color);
    }

    public void setForeground(Color color) {
        Color color1 = getForeground();
        super.setForeground(color);
        pcs.firePropertyChange("foreground", color1, color);
    }

    public void setPoleColor(Color color) {
        poleColor = color;
        repaint();
    }

    public Color getPoleColor() {
        return poleColor;
    }

    public void setZeroColor(Color color) {
        zeroColor = color;
        repaint();
    }

    public Color getZeroColor() {
        return zeroColor;
    }

    public void setCrossColor(Color color) {
        crossColor = color;
        repaint();
    }

    public Color getCrossColor() {
        return crossColor;
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    private boolean inside;
    private boolean isZero;
    private boolean selectedRoot;
    private boolean delRoot;
    private boolean multi;
    private int cursorX;
    private int cursorY;
    private int rootNumber;
    private double xMax;
    private double yMax;
    private Vector zeros;
    private Vector poles;
    private Root newRoot;
    int Width;
    int Height;
    int thickness;
    HsFrame hs;
    Hs3DFrame hs3D;
    SPlaneFrame sFrame;
    EditRootFrame editRoot;
    Vector params;
    private Color poleColor;
    private Color zeroColor;
    private Color crossColor;
    private PopupMenu pop;
    private MenuItem m1;
    private MenuItem m2;
    private MenuItem m3;
    private MenuItem m4;
    private MenuItem m5;
    private MenuItem m6;
    private MenuItem m7;
    private MenuItem m8;
    private MenuItem m9_1;
    private MenuItem m9_2;
    private MenuItem m9_3;
    private MenuItem m9_4;
    private MenuItem m9_5;
    private MenuItem m10;
    private MenuItem m11;
    private MenuItem m12;
    private Menu m9;
    private Dimension offDimension;
    private transient Image offImage;
    private transient Graphics offGraphics;
    private Vector bodeListeners;
    private Vector myMouseListeners;
    private PropertyChangeSupport pcs;
}
