package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Polynom.java

import java.io.Serializable;

public class Polynom
        implements Serializable {

    public Polynom() {
        p1 = null;
        p2 = null;
        c1 = null;
        c2 = null;
    }

    public double[] getQuotient() {
        if (p1 != null) {
            return p1;
        } else {
            double ad[] = new double[1];
            ad[0] = 0.0D;
            return ad;
        }
    }

    public double[] getRest() {
        if (p2 != null) {
            return p2;
        } else {
            double ad[] = new double[1];
            ad[0] = 0.0D;
            return ad;
        }
    }

    public Complex[] getQuotientCmpl() {
        if (c1 != null) {
            return c1;
        } else {
            Complex acomplex[] = new Complex[1];
            acomplex[0] = new Complex();
            return acomplex;
        }
    }

    public Complex[] getRestCmpl() {
        if (c2 != null) {
            return c2;
        } else {
            Complex acomplex[] = new Complex[1];
            acomplex[0] = new Complex();
            return acomplex;
        }
    }

    public double[] getNumerator() {
        return getQuotient();
    }

    public double[] getDenominator() {
        return getRest();
    }

    public Complex[] getNumeratorCmpl() {
        return getQuotientCmpl();
    }

    public Complex[] getDenominatorCmpl() {
        return getRestCmpl();
    }

    public void divide(double ad[], double ad1[]) {
        if (ad.length >= ad1.length) {
            int i = (ad.length - ad1.length) + 1;
            p1 = new double[i];
            p2 = new double[ad.length];
            System.arraycopy(ad, 0, p2, 0, ad.length);
            for (int j = 0; j < i; j++) {
                p1[j] = p2[j] / ad1[0];
                for (int k = 0; k < ad1.length; k++)
                    p2[j + k] -= p1[j] * ad1[k];

            }

            return;
        } else {
            p1 = new double[1];
            p1[0] = 0.0D;
            p2 = new double[ad.length];
            System.arraycopy(ad, 0, p2, 0, ad.length);
            return;
        }
    }

    public void divide(Complex acomplex[], Complex acomplex1[]) {
        if (acomplex.length >= acomplex1.length) {
            int i = (acomplex.length - acomplex1.length) + 1;
            c1 = new Complex[i];
            c2 = new Complex[acomplex.length];
            System.arraycopy(acomplex, 0, c2, 0, acomplex.length);
            for (int j = 0; j < i; j++) {
                c1[j] = c2[j].div(acomplex1[0]);
                for (int k = 0; k < acomplex1.length; k++)
                    c2[j + k] = c2[j + k].sub(c1[j].mul(acomplex1[k]));

            }

            return;
        } else {
            c1 = new Complex[1];
            c1[0] = new Complex();
            c2 = new Complex[acomplex.length];
            System.arraycopy(acomplex, 0, c2, 0, acomplex.length);
            return;
        }
    }

    public double[] multiply(double ad[], double ad1[]) {
        if (ad.length != 0 && ad1.length != 0) {
            double ad2[] = new double[(ad.length + ad1.length) - 1];
            for (int i = 0; i < ad2.length; i++)
                ad2[i] = 0.0D;

            if (ad.length > ad1.length) {
                for (int j = 0; j < ad1.length; j++) {
                    for (int l = 0; l < ad.length; l++)
                        ad2[l + j] += ad1[j] * ad[l];

                }

            } else {
                for (int k = 0; k < ad.length; k++) {
                    for (int i1 = 0; i1 < ad1.length; i1++)
                        ad2[i1 + k] += ad1[i1] * ad[k];

                }

            }
            return ad2;
        } else {
            double ad3[] = new double[1];
            ad3[0] = 0.0D;
            return ad3;
        }
    }

    public Complex[] multiply(Complex acomplex[], Complex acomplex1[]) {
        if (acomplex.length != 0 && acomplex1.length != 0) {
            Complex acomplex2[] = new Complex[(acomplex.length +
                    acomplex1.length) -
                    1];
            for (int i = 0; i < acomplex2.length; i++)
                acomplex2[i] = new Complex();

            if (acomplex.length > acomplex1.length) {
                for (int j = 0; j < acomplex1.length; j++) {
                    for (int l = 0; l < acomplex.length; l++)
                        acomplex2[l + j] =
                                acomplex2[l + j].add(
                                        acomplex1[j].mul(acomplex[l]));

                }

            } else {
                for (int k = 0; k < acomplex.length; k++) {
                    for (int i1 = 0; i1 < acomplex1.length; i1++)
                        acomplex2[i1 + k] =
                                acomplex2[i1 + k].add(
                                        acomplex1[i1].mul(acomplex[k]));

                }

            }
            return acomplex2;
        } else {
            Complex acomplex3[] = new Complex[1];
            acomplex3[0] = new Complex();
            return acomplex3;
        }
    }

    public double[] add(double ad[], double ad1[]) {
        if (ad.length != 0 && ad1.length != 0) {
            double ad2[];
            if (ad.length > ad1.length) {
                ad2 = new double[ad.length];
                System.arraycopy(ad, 0, ad2, 0, ad.length);
                for (int i = 0; i < ad1.length; i++)
                    ad2[ad.length - i - 1] += ad1[ad1.length - i - 1];

            } else {
                ad2 = new double[ad1.length];
                System.arraycopy(ad1, 0, ad2, 0, ad1.length);
                for (int j = 0; j < ad.length; j++)
                    ad2[ad1.length - j - 1] += ad[ad.length - j - 1];

            }
            return ad2;
        } else {
            double ad3[] = new double[1];
            ad3[0] = 0.0D;
            return ad3;
        }
    }

    public Complex[] add(Complex acomplex[], Complex acomplex1[]) {
        if (acomplex.length != 0 && acomplex1.length != 0) {
            Complex acomplex2[];
            if (acomplex.length > acomplex1.length) {
                acomplex2 = new Complex[acomplex.length];
                System.arraycopy(acomplex,
                        0,
                        acomplex2,
                        0,
                        acomplex.length);
                for (int i = 0; i < acomplex1.length; i++)
                    acomplex2[acomplex.length - i - 1] =
                            acomplex2[acomplex.length - i - 1].add(
                                    acomplex1[acomplex1.length - i - 1]);

            } else {
                acomplex2 = new Complex[acomplex1.length];
                System.arraycopy(acomplex1,
                        0,
                        acomplex2,
                        0,
                        acomplex1.length);
                for (int j = 0; j < acomplex.length; j++)
                    acomplex2[acomplex.length - j - 1] =
                            acomplex2[acomplex1.length - j - 1].add(
                                    acomplex1[acomplex.length - j - 1]);

            }
            return acomplex2;
        } else {
            Complex acomplex3[] = new Complex[1];
            acomplex3[0] = new Complex();
            return acomplex3;
        }
    }

    public double[] sub(double ad[], double ad1[]) {
        if (ad.length != 0 && ad1.length != 0) {
            double ad2[];
            if (ad.length > ad1.length) {
                ad2 = new double[ad.length];
                System.arraycopy(ad, 0, ad2, 0, ad.length);
                for (int i = 0; i < ad1.length; i++)
                    ad2[ad.length - i - 1] -= ad1[ad1.length - i - 1];

            } else {
                ad2 = new double[ad1.length];
                System.arraycopy(ad1, 0, ad2, 0, ad1.length);
                for (int j = 0; j < ad.length; j++)
                    ad2[ad1.length - j - 1] -= ad[ad.length - j - 1];

                for (int k = 0; k < ad1.length; k++)
                    ad2[k] = -ad2[k];

            }
            return ad2;
        } else {
            double ad3[] = new double[1];
            ad3[0] = 0.0D;
            return ad3;
        }
    }

    public Complex[] sub(Complex acomplex[], Complex acomplex1[]) {
        if (acomplex.length != 0 && acomplex1.length != 0) {
            Complex acomplex2[];
            if (acomplex.length > acomplex1.length) {
                acomplex2 = new Complex[acomplex.length];
                System.arraycopy(acomplex,
                        0,
                        acomplex2,
                        0,
                        acomplex.length);
                for (int i = 0; i < acomplex1.length; i++)
                    acomplex2[acomplex.length - i - 1] =
                            acomplex2[acomplex.length - i - 1].sub(
                                    acomplex1[acomplex1.length - i - 1]);

            } else {
                acomplex2 = new Complex[acomplex1.length];
                System.arraycopy(acomplex1,
                        0,
                        acomplex2,
                        0,
                        acomplex1.length);
                for (int j = 0; j < acomplex.length; j++)
                    acomplex2[acomplex1.length - j - 1] =
                            acomplex2[acomplex1.length - j - 1].sub(
                                    acomplex[acomplex.length - j - 1]);

                for (int k = 0; k < acomplex1.length; k++)
                    acomplex2[k] = acomplex2[k].neg();

            }
            return acomplex2;
        } else {
            Complex acomplex3[] = new Complex[1];
            acomplex3[0] = new Complex();
            return acomplex3;
        }
    }

    public double[] derive(double ad[], int i) {
        int j = ad.length;
        i = Math.abs(i);
        if (j <= i) {
            double ad1[] = new double[1];
            ad1[0] = 0.0D;
            return ad1;
        }
        double ad2[] = new double[j - i];
        for (int k = 0; k < ad2.length; k++)
            ad2[k] = ad[k] * (double) factorial2(j - k - 1, i);

        return ad2;
    }

    public Complex[] derive(Complex acomplex[], int i) {
        int j = acomplex.length;
        i = Math.abs(i);
        if (j <= i) {
            Complex acomplex1[] = new Complex[1];
            acomplex1[0] = new Complex();
            return acomplex1;
        }
        Complex acomplex2[] = new Complex[j - i];
        for (int k = 0; k < acomplex2.length; k++)
            acomplex2[k] = acomplex[k].scale(factorial2(j - k - 1, i));

        return acomplex2;
    }

    public int factorial(int i) {
        int j = 1;
        if (i < 1)
            return j;
        for (int k = 2; k < i + 1; k++)
            j *= k;

        return j;
    }

    public int factorial2(int i, int j) {
        int k = 1;
        if (i < 1)
            return k;
        for (int l = i; l > i - j; l--)
            k *= l;

        return k;
    }

    public void derive(double ad[], double ad1[]) {
        int i = ad1.length;
        int j = ad.length;
        int k = (j + i) - 2;
        if (k <= 0) {
            p1 = new double[1];
            p1[0] = 0.0D;
            return;
        } else {
            p2 = multiply(ad1, ad1);
            p1 =
                    sub(multiply(derive(ad, 1), ad1),
                            multiply(ad, derive(ad1, 1)));
            return;
        }
    }

    public void derive(Complex acomplex[], Complex acomplex1[]) {
        int i = acomplex1.length;
        int j = acomplex.length;
        int k = (j + i) - 2;
        if (k <= 0) {
            c1 = new Complex[1];
            c1[0] = new Complex();
            return;
        } else {
            c2 = multiply(acomplex1, acomplex1);
            c1 =
                    sub(multiply(derive(acomplex, 1), acomplex1),
                            multiply(acomplex, derive(acomplex1, 1)));
            return;
        }
    }

    public double evaluate(double ad[], double d) {
        double d1 = 0.0D;
        if (ad.length < 1)
            return 0.0D;
        for (int i = 0; i < ad.length; i++)
            d1 += ad[i] * Math.pow(d, ad.length - i - 1);

        return d1;
    }

    public Complex evaluate(Complex acomplex[], Complex complex) {
        Complex complex1 = new Complex();
        if (acomplex.length < 1)
            return new Complex();
        for (int i = 0; i < acomplex.length; i++)
            complex1 =
                    complex1.add(
                            acomplex[i].mul(
                                    complex.pow(acomplex.length - i - 1)));

        return complex1;
    }

    public double evaluate(double ad[], double ad1[], double d) {
        return evaluate(ad, d) / evaluate(ad1, d);
    }

    public Complex evaluate(Complex acomplex[],
                            Complex acomplex1[],
                            Complex complex) {
        return evaluate(acomplex, complex).div(
                evaluate(acomplex1, complex));
    }

    public double evaluate(double d) {
        return evaluate(p1, d) / evaluate(p2, d);
    }

    public Complex evaluate(Complex complex) {
        return evaluate(c1, complex).div(evaluate(c2, complex));
    }

    public double[] integrate(double ad[], double d) {
        double ad1[] = new double[ad.length + 1];
        System.arraycopy(ad, 0, ad1, 0, ad.length);
        for (int i = 0; i < ad.length; i++)
            ad1[i] /= ad.length - i;

        ad1[ad.length] = d;
        return ad1;
    }

    public Complex[] integrate(Complex acomplex[], Complex complex) {
        Complex acomplex1[] = new Complex[acomplex.length + 1];
        System.arraycopy(acomplex, 0, acomplex1, 0, acomplex.length);
        for (int i = 0; i < acomplex.length; i++)
            acomplex1[i] = acomplex1[i].div(acomplex.length - i);

        acomplex1[acomplex.length] = complex;
        return acomplex1;
    }

    protected double p1[];
    protected double p2[];
    protected Complex c1[];
    protected Complex c2[];
}
