package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   HsCanvas.java

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Vector;

public class HsCanvas extends Canvas
        implements MouseListener, MouseMotionListener, Serializable {

    public HsCanvas() {
        setCursor(new Cursor(1));
        setFont(new Font("TimesNewRoman", 1, 16));
        setBackground(Color.white);
        setForeground(Color.black);
        addMouseListener(this);
        addMouseMotionListener(this);
        xMouse = yMouse = 0;
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        g.drawImage(boxImage, 0, 0, this);
        g.setColor(getBackground());
        g.fillRect(0, height, width + 20, 22);
        g.setColor(getForeground());
        if (xMouse >= 0 &&
                yMouse >= 0 &&
                xMouse < width &&
                yMouse < height)
            g.drawString("H(s)= " + mag[xMouse + width * yMouse],
                    5,
                    height + 18);
    }

    public void mouseDragged(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent mouseevent) {
        xMouse = mouseevent.getX();
        yMouse = mouseevent.getY();
        repaint();
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public int findColor(double d) {
        int i;
        if (d < 1.0D)
            i = (int) (d * 200D) + 56;
        else if (d < 5D) {
            i = (int) (d * 40D) + 56;
            i <<= 8;
        } else if (d > 20D) {
            i = 0xffffff;
        } else {
            i = (int) (d * 10D) + 56;
            i <<= 16;
        }
        return i;
    }

    public void calculate() {
        for (int i = 0; i < width; i++) {
            double d = ((double) ((i - width / 2) * 2) * xmax) /
                    (double) width;
            for (int j = 0; j < height; j++) {
                double d1 = ((double) ((height / 2 - j) * 2) * ymax) /
                        (double) height;
                double d2 = 1.0D;
                for (int k = 0; k < zeros.size(); k++) {
                    double d3 = ((Zero) zeros.elementAt(k)).getReal();
                    double d5 = ((Zero) zeros.elementAt(k)).getImag();
                    d2 *= (d3 - d) * (d3 - d) + (d5 - d1) * (d5 - d1);
                    if (d5 != 0.0D) {
                        d5 = -d5;
                        d2 *= (d3 - d) * (d3 - d) + (d5 - d1) * (d5 - d1);
                    }
                }

                for (int l = 0; l < poles.size(); l++) {
                    double d4 = ((Pole) poles.elementAt(l)).getReal();
                    double d6 = ((Pole) poles.elementAt(l)).getImag();
                    d2 /= (d4 - d) * (d4 - d) + (d6 - d1) * (d6 - d1);
                    if (d6 != 0.0D) {
                        d6 = -d6;
                        d2 /= (d4 - d) * (d4 - d) + (d6 - d1) * (d6 - d1);
                    }
                }

                d2 = Math.sqrt(d2);
                mag[i + j * width] = d2;
                result[i + j * width] = 0xff000000 | findColor(d2);
            }

        }

    }

    public void newInfo(Vector vector,
                        Vector vector1,
                        Dimension dimension,
                        double d,
                        double d1) {
        xmax = d;
        ymax = d1;
        width = dimension.width;
        height = dimension.height;
        if (height % 2 != 0)
            height--;
        setSize(width, height + 20);
        zeros = new Vector();
        poles = new Vector();
        synchronized (this) {
            if (vector1 != null && vector1.size() > 0) {
                for (int i = 0; i < vector1.size(); i++)
                    poles.addElement(new Pole((Pole) vector1.elementAt(i)));

            }
            if (vector != null && vector.size() > 0) {
                for (int j = 0; j < vector.size(); j++)
                    zeros.addElement(new Zero((Zero) vector.elementAt(j)));

            }
        }
        result = new int[width * height];
        mag = new double[width * height];
        calculate();
        box = new MemoryImageSource(width, height, result, 0, width);
        boxImage = createImage(box);
        repaint();
    }

    Vector zeros;
    Vector poles;
    int result[];
    int buffer[];
    double mag[];
    int width;
    int height;
    int xMouse;
    int yMouse;
    double xmax;
    double ymax;
    double K;
    Dimension offDimension;
    MemoryImageSource box;
    Image boxImage;
    Image offImage;
    Graphics offGraphics;
}
