package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Hs3DFrame.java

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

public class Hs3DFrame extends Frame
        implements ActionListener, ItemListener {

    public Hs3DFrame() {
        super("| H(s) | in 3D");
        canvas = new Hs3DCanvas();
        mainMenu = new MenuBar();
        help = new Menu("Help");
        file = new Menu("Window");
        bgcolor = new Menu("BG Color");
        option = new Menu("Options");
        grid = new Menu("Grid");
        palette = new Menu("Palette");
        close = new MenuItem("Close");
        axes = new CheckboxMenuItem("Axis", true);
        wire = new CheckboxMenuItem("Mesh", false);
        value = new CheckboxMenuItem("Values", false);
        surf = new CheckboxMenuItem("Surface", true);
        rot = new CheckboxMenuItem("Rotate", false);
        c1 = new CheckboxMenuItem("Black", true);
        c2 = new CheckboxMenuItem("White", false);
        c3 = new CheckboxMenuItem("Gray I", false);
        c4 = new CheckboxMenuItem("Orange", false);
        c5 = new CheckboxMenuItem("Pink", false);
        c6 = new CheckboxMenuItem("Gray II", false);
        c7 = new CheckboxMenuItem("Yellow", false);
        g1 = new CheckboxMenuItem("10 X 10", false);
        g2 = new CheckboxMenuItem("20 X 20", true);
        g3 = new CheckboxMenuItem("30 X 30", false);
        g4 = new CheckboxMenuItem("40 X 40", false);
        p0 = new CheckboxMenuItem("Default", true);
        p1 = new CheckboxMenuItem("Warm", false);
        p2 = new CheckboxMenuItem("Cold", false);
        file.add(close);
        option.add(axes);
        option.add(wire);
        option.add(value);
        option.add(surf);
        option.add(rot);
        palette.add(p0);
        palette.add(p1);
        palette.add(p2);
        bgcolor.add(c1);
        bgcolor.add(c2);
        bgcolor.add(c3);
        bgcolor.add(c4);
        bgcolor.add(c5);
        bgcolor.add(c6);
        bgcolor.add(c7);
        grid.add(g1);
        grid.add(g2);
        grid.add(g3);
        grid.add(g4);
        mainMenu.add(file);
        mainMenu.add(bgcolor);
        mainMenu.add(grid);
        mainMenu.add(option);
        mainMenu.add(palette);
        mainMenu.setHelpMenu(help);
        setMenuBar(mainMenu);
        setSize(600, 600);
        setCursor(new Cursor(1));
        setVisible(false);
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent windowevent) {
                setVisible(false);
                canvas.stopThread();
            }

        });
        close.addActionListener(this);
        axes.addItemListener(this);
        wire.addItemListener(this);
        value.addItemListener(this);
        surf.addItemListener(this);
        rot.addItemListener(this);
        c1.addItemListener(this);
        c2.addItemListener(this);
        c3.addItemListener(this);
        c4.addItemListener(this);
        c5.addItemListener(this);
        c6.addItemListener(this);
        c7.addItemListener(this);
        g1.addItemListener(this);
        g2.addItemListener(this);
        g3.addItemListener(this);
        g4.addItemListener(this);
        p0.addItemListener(this);
        p1.addItemListener(this);
        p2.addItemListener(this);
        add(canvas);
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == close) {
            setVisible(false);
            canvas.stopThread();
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        Object obj = itemevent.getSource();
        if (obj == c1) {
            c1.setState(true);
            c2.setState(false);
            c3.setState(false);
            c4.setState(false);
            c5.setState(false);
            c6.setState(false);
            c7.setState(false);
            canvas.newBgcolor(Color.black);
            return;
        }
        if (obj == c2) {
            c1.setState(false);
            c2.setState(true);
            c3.setState(false);
            c4.setState(false);
            c5.setState(false);
            c6.setState(false);
            c7.setState(false);
            canvas.newBgcolor(Color.white);
            return;
        }
        if (obj == c3) {
            c1.setState(false);
            c2.setState(false);
            c3.setState(true);
            c4.setState(false);
            c5.setState(false);
            c6.setState(false);
            c7.setState(false);
            canvas.newBgcolor(Color.gray);
            return;
        }
        if (obj == c4) {
            c1.setState(false);
            c2.setState(false);
            c3.setState(false);
            c4.setState(true);
            c5.setState(false);
            c6.setState(false);
            c7.setState(false);
            canvas.newBgcolor(Color.orange);
            return;
        }
        if (obj == c5) {
            c1.setState(false);
            c2.setState(false);
            c3.setState(false);
            c4.setState(false);
            c5.setState(true);
            c6.setState(false);
            c7.setState(false);
            canvas.newBgcolor(Color.pink);
            return;
        }
        if (obj == c6) {
            c1.setState(false);
            c2.setState(false);
            c3.setState(false);
            c4.setState(false);
            c5.setState(false);
            c6.setState(true);
            c7.setState(false);
            canvas.newBgcolor(Color.lightGray);
            return;
        }
        if (obj == c7) {
            c1.setState(false);
            c2.setState(false);
            c3.setState(false);
            c4.setState(false);
            c5.setState(false);
            c6.setState(false);
            c7.setState(true);
            canvas.newBgcolor(Color.yellow);
            return;
        }
        if (obj == g1) {
            g1.setState(true);
            g2.setState(false);
            g3.setState(false);
            g4.setState(false);
            canvas.newNpoints(10);
            return;
        }
        if (obj == g2) {
            g1.setState(false);
            g2.setState(true);
            g3.setState(false);
            g4.setState(false);
            canvas.newNpoints(20);
            return;
        }
        if (obj == g3) {
            g1.setState(false);
            g2.setState(false);
            g3.setState(true);
            g4.setState(false);
            canvas.newNpoints(30);
            return;
        }
        if (obj == g4) {
            g1.setState(false);
            g2.setState(false);
            g3.setState(false);
            g4.setState(true);
            canvas.newNpoints(40);
            return;
        }
        if (obj == p0) {
            p0.setState(true);
            p1.setState(false);
            p2.setState(false);
            canvas.palette(0);
            return;
        }
        if (obj == p1) {
            p0.setState(false);
            p1.setState(true);
            p2.setState(false);
            canvas.palette(1);
            return;
        }
        if (obj == p2) {
            p0.setState(false);
            p1.setState(false);
            p2.setState(true);
            canvas.palette(2);
            return;
        }
        if (obj == axes) {
            canvas.axisOn(axes.getState());
            return;
        }
        if (obj == wire) {
            canvas.wireOn(wire.getState());
            return;
        }
        if (obj == value) {
            canvas.valueOn(value.getState());
            return;
        }
        if (obj == surf) {
            canvas.surfOn(surf.getState());
            return;
        }
        if (obj == rot)
            canvas.rotOn(rot.getState());
    }

    public void wake(Vector vector, Vector vector1, double d, double d1) {
        canvas.newInfo(vector, vector1, d, d1);
        setVisible(true);
    }

    Hs3DCanvas canvas;
    MenuBar mainMenu;
    Menu help;
    Menu file;
    Menu bgcolor;
    Menu option;
    Menu grid;
    Menu palette;
    MenuItem close;
    CheckboxMenuItem c1;
    CheckboxMenuItem c2;
    CheckboxMenuItem c3;
    CheckboxMenuItem c4;
    CheckboxMenuItem c5;
    CheckboxMenuItem c6;
    CheckboxMenuItem c7;
    CheckboxMenuItem g1;
    CheckboxMenuItem g2;
    CheckboxMenuItem g3;
    CheckboxMenuItem g4;
    CheckboxMenuItem axes;
    CheckboxMenuItem wire;
    CheckboxMenuItem value;
    CheckboxMenuItem surf;
    CheckboxMenuItem rot;
    CheckboxMenuItem p0;
    CheckboxMenuItem p1;
    CheckboxMenuItem p2;
}
