package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ComplexNumber.java


class ComplexNumber {

    ComplexNumber(Root root) {
        real = -root.getReal();
        imag = -root.getImag();
    }

    ComplexNumber(double d, double d1) {
        real = d;
        imag = d1;
    }

    ComplexNumber(double d) {
        real = d;
        imag = 0.0D;
    }

    ComplexNumber(ComplexNumber complexnumber, double d) {
        real = complexnumber.getReal();
        imag = complexnumber.getImag();
        gain = d;
    }

    ComplexNumber(ComplexNumber complexnumber) {
        real = complexnumber.getReal();
        imag = complexnumber.getImag();
        gain = complexnumber.getGain();
    }

    ComplexNumber() {
        real = 0.0D;
        imag = 0.0D;
    }

    public double getImag() {
        return imag;
    }

    public double getReal() {
        return real;
    }

    public double getGain() {
        return gain;
    }

    public void setGain(double d) {
        gain = d;
    }

    public void set(double d, double d1) {
        real = d;
        imag = d1;
    }

    public void setImag(double d) {
        imag = d;
    }

    public void setReal(double d) {
        real = d;
    }

    public ComplexNumber add(ComplexNumber complexnumber) {
        return new ComplexNumber(real + complexnumber.getReal(),
                imag + complexnumber.getImag());
    }

    public ComplexNumber sub(ComplexNumber complexnumber) {
        return new ComplexNumber(real - complexnumber.getReal(),
                imag - complexnumber.getImag());
    }

    public ComplexNumber scale(double d) {
        return new ComplexNumber(real * d, imag * d);
    }

    public boolean equals(ComplexNumber complexnumber) {
        return real == complexnumber.getReal() &&
                imag == complexnumber.getImag();
    }

    public ComplexNumber mul(ComplexNumber complexnumber) {
        return new ComplexNumber(
                getReal() * complexnumber.getReal() -
                getImag() * complexnumber.getImag(),
                getReal() * complexnumber.getImag() +
                getImag() * complexnumber.getReal());
    }

    public ComplexNumber div(ComplexNumber complexnumber) {
        ComplexNumber complexnumber1 = new ComplexNumber(this);
        div(complexnumber1,
                complexnumber.getReal(),
                complexnumber.getImag());
        return complexnumber1;
    }

    private static void div(ComplexNumber complexnumber,
                            double d,
                            double d1) {
        double d2;
        double d3;
        if (Math.abs(d) >= Math.abs(d1)) {
            double d4 = 1.0D / (d + d1 * (d1 / d));
            d2 =
                    d4 *
                    (complexnumber.getReal() +
                    complexnumber.getImag() * (d1 / d));
            d3 =
                    d4 *
                    (complexnumber.getImag() -
                    complexnumber.getReal() * (d1 / d));
        } else {
            double d5 = 1.0D / (d * (d / d1) + d1);
            d2 =
                    d5 *
                    (complexnumber.getReal() * (d / d1) +
                    complexnumber.getImag());
            d3 =
                    d5 *
                    (complexnumber.getImag() * (d / d1) -
                    complexnumber.getReal());
        }
        complexnumber.setReal(d2);
        complexnumber.setImag(d3);
    }

    public double abs() {
        return abs(real, imag);
    }

    private static double abs(double d, double d1) {
        double d2 = Math.abs(d);
        double d3 = Math.abs(d1);
        if (d2 == 0.0D && d3 == 0.0D)
            return 0.0D;
        if (d2 >= d3) {
            double d4 = d1 / d;
            return d2 * Math.sqrt(1.0D + d4 * d4);
        } else {
            double d5 = d / d1;
            return d3 * Math.sqrt(1.0D + d5 * d5);
        }
    }

    ComplexNumber sqrt() {
        double d1 = Math.sqrt(Math.sqrt(real * real + imag * imag));
        double d;
        if (real >= 0.0D)
            d = Math.atan(imag / real) / 2D;
        else if (imag >= 0.0D)
            d = (Math.atan(imag / real) + 3.1415926535897931D) / 2D;
        else
            d = (Math.atan(imag / real) - 3.1415926535897931D) / 2D;
        double d2 = d1 * Math.cos(d);
        double d3 = d1 * Math.sin(d);
        return new ComplexNumber(d2, d3);
    }

    double real;
    double imag;
    double gain;
}
