/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package sound.dialTones;

import gui.In;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 2, 2005
 * <p/>
 * Time: 6:28:42 AM
 */
public class ToneMap {
    public DTMF[] getDtmfs(String s) {
        char ca[] = s.toCharArray();
        DTMF d[] = new DTMF[ca.length];
        for (int i = 0; i < ca.length; i++)
            d[i] = getDtmf(ca[i]);
        return d;
    }

    public void play(DTMF d[]) {
        for (int i = 0; i < d.length; i++)
            d[i].play();
    }

    public void playNumber(String s) {
        play(getDtmfs(s));
    }

    /**
     * Map a character into two DTMF tones. If the character cannot be
     * found, the frequency is -1.
     */
    public DTMF getDtmf(char c) {
        int F1 = -1;
        int F2 = -1;
        switch (c) {
            case '0':
                F1 = 1336;
                F2 = 941;
                break;
            case '1':
                F1 = 1209;
                F2 = 697;
                break;
            case '2':
            case 'A':
            case 'B':
            case 'C':
                F1 = 1336;
                F2 = 697;
                break;
            case '3':
            case 'D':
            case 'E':
            case 'F':
                F1 = 1477;
                F2 = 697;
                break;
            case '4':
            case 'G':
            case 'H':
            case 'I':
                F1 = 1209;
                F2 = 770;
                break;
            case '5':
            case 'J':
            case 'K':
            case 'L':
                F1 = 1336;
                F2 = 770;
                break;
            case '6':
            case 'M':
            case 'N':
            case 'O':
                F1 = 1477;
                F2 = 770;
                break;
            case '7':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
                F1 = 1209;
                F2 = 852;
                break;
            case '8':
            case 'T':
            case 'U':
            case 'V':
                F1 = 1336;
                F2 = 852;
                break;
            case '9':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
                F1 = 1477;
                F2 = 852;
                break;
            case '*':
                F1 = 1209;
                F2 = 941;
                break;
            case '#':
                F1 = 1477;
                F2 = 941;
                break;
            case ',': // pause
                F1 = 0;
                F2 = 0;
                break;
        }
        return new DTMF(F1, F2);
    }

    public static void main(String args[]) {
        ToneMap tm = new ToneMap();
        do
            tm.playNumber("877-0890");
        while (In.getBoolean("again?"));
    }

}
