package serialPort;

/**
 * Created by
 * User: lyon
 * Date: Dec 29, 2003
 * Time: 10:06:24 AM
 *
 */

import gnu.io.*;
import gui.In;
import gui.run.DialBean;
import gui.run.SerialPortBean;
import utils.StringUtils;
import utils.SystemUtils;

import java.io.*;

public class Utils implements CommPortOwnershipListener {
    private static Utils utils = null;
    private CommPortIdentifier cpid;
    private SerialPort serialPort;
    private PrintStream printStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private CommPort commPort;
    private SerialPortBean serialPortBean;

    private Utils(SerialPortBean spb)
            throws
            UnsupportedCommOperationException,
                   IOException,
                   PortInUseException {
        this.serialPortBean = spb;
        init();

    }

    private void init() throws
            UnsupportedCommOperationException,
                               PortInUseException,
                               IOException,
                               PortInUseException {
        //System.loadLibrary("rxtxSerial");
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu== null) return;
        cpid = cpu.getCommPortIdentifierByName(
                serialPortBean.getPortName());
        if (cpid == null) {
            cpid = cpu.getACommPort();
            serialPortBean.setPortName(cpid.getName());
            serialPortBean.save();
        }
        if (cpid.isCurrentlyOwned())
            cpid.removePortOwnershipListener(this);
        cpid.addPortOwnershipListener(this);
        final String portName = serialPortBean.getPortName();
        System.out.println("trying to open:"+portName);

        commPort = cpid.open(serialPortBean.getPortName(),1000);
        serialPort = (SerialPort) commPort;
        serialPort.setSerialPortParams(
                serialPortBean.getBaudRate(),
                serialPortBean.getDatabits(),
                serialPortBean.getStopbits(),
                serialPortBean.getParity());
        serialPort.setDTR(true);
        serialPort.setRTS(true);
        serialPort.setFlowControlMode(serialPortBean.getFlowControlIn());
        serialPort.setFlowControlMode(serialPortBean.getFlowControlOut());
        inputStream = this.serialPort.getInputStream();
        outputStream = this.serialPort.getOutputStream();
        printStream = new PrintStream(outputStream);

    }

    public static Utils getSerialPortUtils(SerialPortBean spb) {

        if (utils != null) return utils;


        try {
            utils = new Utils(spb);
        } catch (UnsupportedCommOperationException e) {
            In.message(e);

        } catch (IOException e) {
            In.message(e);

        } catch (PortInUseException e) {
            In.message(e);

        }
        return utils;
    }

    public static void main(String args[]) {
        System.out.println("restore...");
        Utils u = null;
        u
                = Utils.getSerialPortUtils(
                        SerialPortBean.restore());
        System.out.println("libraryPath=" + SystemUtils.getLibraryPath());
        try {
            u.listPorts();
        } catch (ClassNotFoundException e) {
            In.message(e);

        }
        System.out.println(
                "Make sure the dll is" +
                " in the lib path and " +
                "the properties are in the jre lib" +
                " also make sure that comm.jar is in the class path");
        do
            try {
                u.dial(In.getString("enter number"), DialBean.restore());
            } catch (Exception e) {
                In.message(e);

            }
        while (In.getBoolean("again?"));
    }



    public void dial(String number, DialBean db)
            throws IOException {
        startPrintThread();
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu == null) return;
        cpu.sleep();
        loud();

        cpu.sleep();
        englishResultCodes();

        cpu.sleep();
        //numericResultCodes(ps);
        String dialString = filterOutSpacesParensAndDashes(number);
        dialString= getDialString(dialString, db);
        System.out.println(dialString);
        printStream.print(
                dialString +
                '\r');
        cpu.sleep();
        if (In.getBoolean("hang up?"))
            hangup();
    }

    public String filterOutSpacesParensAndDashes(String s) {
        StringBuffer sb = new StringBuffer();
        char ca[] = s.toCharArray();
        for (int i=0; i < ca.length; i++){
            final char c = ca[i];
            if (c=='-') continue;
            if (Character.isDigit(c)) sb.append(c);
            if (c==',') sb.append(c);
        }
        return sb.toString();
    }

    public String getDialString(String number, DialBean dialBean) {
        number = number.trim();
        String cc = dialBean.getCallingCardNumber();
        if (cc == null) return getPrefix(dialBean) + number;
        if (!isLongDistance(number)) return getPrefix(dialBean) + number;
        return getPrefix(dialBean) +
                filterOutSpacesParensAndDashes(cc + number);
    }

    public boolean isLongDistance(String number) {
        if (number.startsWith("1")) return true;
        if (StringUtils.getNumberOfDigits(number)>7) return true;
        return false;
    }

    private String getPrefix(DialBean dialBean) {
        if (dialBean.isToneDial())
            return "atdt";
        else
            return "atdp";
    }


    private  void startPrintThread()
            throws IOException {
        if (serialPort == null) return;
        final DataInputStream dis =
                new DataInputStream(serialPort.getInputStream());
        if (dis.available()==0) return;//at eof.
        Thread t = new Thread(
                new Runnable() {
                    public void run() {
                        try {
                            readAndPrint(dis);

                        } catch (IOException e) {
                            In.message(e);

                        }
                    }
                });
        t.start();
    }

    private void readAndPrint(final DataInputStream dis) throws IOException {
        final byte x = dis.readByte();

        System.out.print(x);
        System.out.flush();
        if (x == 13) System.out.println();
    }


    private void hangup() {
        printStream.print("ath0\r");
        close();
    }

    private void loud() {
        printStream.print("atL3\r");
    }

    public  void echoResult() {
        printStream.print("atE1\r" + (char) 13);
    }

    public void englishResultCodes() {
        printStream.print("atV1\r");
    }

    public void setNumberOfRingsBeforeAnswer(int nor) {
        printStream.print("atS0=" +
                nor +
                "&w0\r");
    }

    public  void numericResultCodes() {
        printStream.print("atV0\r");
    }


    public void sendString(String s)
            throws IOException {
        byte b[] = s.getBytes();
        outputStream.write(b);
    }

    /* If you are having trouble under OSX, use
  copy rxtx-2.1-6/MACOSX_IDE/CW/librxtxSerial.jnilib
  to:
  /System/Library/Frameworks/JavaVM.framework/Versions/1.4.1/Libraries
   or go to:
   http://home.comcast.net/~d.sopchak/macdobs/RXTX_Jag.pkg.zip
   To get the mac package.
   http://rxtx.org/ is the home page.
   Run the config as root;
   grep: /System/Library/Frameworks/JavaVM.framework/
   Versions/1.4.2/Home/lib/javax.comm.properties: No such file or directory
------------------------------------------------------
RxTx requires the following information in
/System/Library/Frameworks/JavaVM.framework/
Versions/1.4.2/Home/lib/javax.comm.properties:

Driver=gnu.io.RXTXCommDriver

  */
    public void listPorts() throws ClassNotFoundException {

        System.out.println("testPortIdentifiers:start");
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu == null) return;
        System.out.println("getting comm port identifiers...");
        CommPortIdentifier cpid[] = cpu.getComPortIdentifiers();
        System.out.println("comm port identifiers returned...");
        if (cpid.length == 0) {
            In.message("no com ports detected, program terminates.");
            System.exit(0);
        }
        for (int i = 0; i < cpid.length; i++)
            cpu.print(cpid[i]);
        System.out.println("testPortIdentifiers:done");

    }

    public void close() {
        if (serialPort == null) return;
        if (inputStream != null) {
            try {
                inputStream.close();
                inputStream = null;
            } catch (IOException e) {
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
                outputStream = null;
            } catch (IOException e) {
            }
        }
        serialPort.close();
        serialPort.removeEventListener();
        cpid.removePortOwnershipListener(this);
        serialPort = null;
        utils = null;
    }


    public void ownershipChange(int i) {
        if (cpid.isCurrentlyOwned()) return;
        cpid.removePortOwnershipListener(this);
    }
}
