/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package serialPort;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 14, 2005
 * <p/>
 * Time: 4:58:10 AM
 */



import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPort;

import java.io.InputStream;
import java.util.Enumeration;

public class PortTest {
    public static void main(String[] args) {
        String portName;
        CommPortIdentifier portId;
        Enumeration
                e = gnu.io.CommPortIdentifier.getPortIdentifiers();

        System.out.println("Ports found:");

        while (
                e.hasMoreElements()) {
            portId = (CommPortIdentifier)
                    e.nextElement();
            System.out.println("  - " + portId.getName());
        }

        if (args.length <= 0) {
            System.out.println("usage: PortTest <portname>");
            return;
        }

        portName = args[0];

        try {
            portId = CommPortIdentifier.getPortIdentifier(portName);
        } catch (NoSuchPortException n) {
            n.printStackTrace();
            return;
        }

        int val;
        byte[] valArray = new byte[128];

        try {
            SerialPort port = (SerialPort) portId.open("PortTest", 5000);
            InputStream in = port.getInputStream();

            System.out.println(
                    "[" + portName + "] 'read()' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read()' test (5000, 0):");
            port.enableReceiveTimeout(5000);
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read()' test (5000, 5):");
            port.enableReceiveThreshold(5);
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" + portName + "] 'read()' test (0, 5):");
            port.disableReceiveTimeout();
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[])' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[])' test (5000, 0):");

            port.enableReceiveTimeout(5000);
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[])' test (5000, 5):");

            port.enableReceiveThreshold(5);
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[])' test (0, 5):");

            port.disableReceiveTimeout();
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[], int, int)' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[], int, int)' test (5000, 0):");
            port.enableReceiveTimeout(5000);
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[], int, int)' test (5000, 5):");
            port.enableReceiveThreshold(5);
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[], int, int)' test (0, 5) (len = 3):");
            port.disableReceiveTimeout();
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portName +
                    "] 'read(byte[], int, int)' test (0, 5) (len = 10):");
            port.disableReceiveTimeout();
            val = in.read(valArray, 0, 10);
            System.out.println("[" + val + "]");

            port.close();
        } catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}
