/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package serialPort;

import gnu.io.CommPortIdentifier;
import gui.In;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 8, 2005
 * <p/>
 * Time: 10:30:33 AM
 */
public final class CommPortUtils {
    private static CommPortUtils cpu= null;
    private CommPortUtils(){

    }
    public static CommPortUtils getCommPortUtils(){
         if (cpu!=null) return cpu;
        cpu = new CommPortUtils();
        return cpu;
    }
    public  void sleep() {
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {

        }
    }

    public  void printResponse(Reader br)
            throws IOException {
        char ca[] = new char[60];
        int i;
        while ((i = br.read(ca)) != -1) {
            final String s = new String(ca, 0, i);
            System.out.print(s);
            if (s.indexOf('\r') != -1) break;
        }
        System.out.println();

    }

    public  Integer[] getBaudRates() {
        return new Integer[]{
            new Integer(300),
            new Integer(1200),
            new Integer(2400),
            new Integer(4800),
            new Integer(9600),
            new Integer(19200),
            new Integer(57600)
        };
    }

    public  CommPortIdentifier getCommPortIdentifierByName(String name) {
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        if (cpid == null) return null;
        for (int i = 0; i < cpid.length; i++) {
            if (cpid[i].getName().equals(name))
                return cpid[i];

        }
        return cpid[0];
    }

    public  CommPortIdentifier[] getComPortIdentifiers() {
        Vector v = new Vector();
        Enumeration pi;
        try {
            pi = CommPortIdentifier.getPortIdentifiers();
        } catch (Exception e) {
            In.message("No serial drivers installed.");
            return null;
        }
        while (pi.hasMoreElements())
            v.addElement(pi.nextElement());
        CommPortIdentifier cpid[] = new CommPortIdentifier[v.size()];
        v.copyInto(cpid);
        return cpid;
    }

    public  String[] getCommPortNames() {
        CommPortIdentifier c[] = getComPortIdentifiers();
        String s[] = new String[c.length];
        for (int i = 0; i < s.length; i++)
            s[i] = c[i].getName();
        return s;
    }

    public  CommPortIdentifier getACommPort() {
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        String s[] = new String[cpid.length];
        for (int i = 0; i < s.length; i++)
            s[i] = cpid[i].getName();
        String cpn = (String) In.multiPrompt(
                s,
                "select a comm port (com2?)",
                "comm port dialog");
        return getCommPortIdentifierByName(cpn);
    }

    public  void print(CommPortIdentifier cpid) {
        System.out.print(
                "port:" +
                cpid.getName() +
                "\t"
                +
                "CurrentOwner:" +
                cpid.getCurrentOwner() +
                "\t"
                +
                "isCurrentlyOwned=" +
                cpid.isCurrentlyOwned());
        // isCurrentlyOwned
        // indicates if another Java
        // application owns the port.
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_SERIAL)
            System.out.println(":PORT_SERIAL");
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_PARALLEL)
            System.out.println(":PORT_PARALLEL");
    }

}
