/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package security;

import futils.Futil;
import gui.In;
import net.rmi.utils.Compile;
import utils.SystemUtils;

import java.io.File;
import java.io.IOException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Feb 13, 2005
 * <p/>
 * Time: 6:15:37 AM
 */
public class WebStartLauncher {
    /**
     * Start web start on the given url, then kill the process, to showAndRegister we
     * have control over stopping and starting a process.
     */
    public static void startWebStart() {
        File webStart = getWebstartLocation();
        String args[] = {
            webStart.toString(),
            "http://showAndRegister.docjava.com:8086/book/cgij/code/jnlp/dhry.Main.jnlp"
        };
        try {
            Runtime rt = Compile.asyncRunExec(args, null);
            rt.exit(0);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Search for the Java web start application. If you cannot find it,
     * prompt the user. In the future, there should be a better way to do
     * this, but what, I don't know. And what if javaws cannot be found
     * because it is not installed? Tricky!
     *
     * @return the java webstart file.
     */
    public static File getWebstartLocation() {
        String s = SystemUtils.getDirectorySeparator();
        // check widows location:
        File f = new File("C:" +
                s +
                "Program Files" +
                s +
                "Java Web Start" +
                s +
                "javaws.exe");
        if (f.exists()) return f;
        // check mac location:
        f = new File("/" +
                "Applications" +
                s +
                "Utilities" +
                s +
                "Java" +
                s +
                "Java Web Start.app" +
                s +
                "Contents" +
                s +
                "MacOS" +
                s +
                "Java Web Start");
        if (f.exists()) return f;
        // check linux location for jdk1.5:
        f = new File("" +
                s +
                "usr" +
                s +
                "java" +
                s +
                "j2sdk1.5.0" +
                s +
                "bin" +
                s +
                "javaws");
        if (f.exists()) return f;
        f =
                Futil.getReadFile(
                        "could not find javaws, please help me locate it");
        if (f == null) {
            In.message("user canceled operation, program terminates");
            System.exit(0);
        }
        String cn = "security.WebstartUtils";
        System.out.println("please add:" + f + " to" + cn);
        return f;
    }
}
