package security;

//import classUtils.pack.DependencyUtils;

import classUtils.pack.PackUtils;
import futils.DirList;
import futils.Futil;
import gui.In;
import sun.security.tools.JarSigner;

import java.io.File;

/**
 * DocJava, Inc. User: lyon Date: May 26, 2004 Time: 7:40:22 AM
 */
public class SignUtils {
    public static void main(String[] args) {
        signGui();

    }

    private static void signGui() {
        WebStartBean wsb = WebStartBean.getFromPreferences();
        final String ks = wsb.getKeyStoreFile();
        final String pw = wsb.getPassword();
        final String alias = wsb.getAlias();

        DirList dl = new DirList(Futil.getReadFileDir("select a dir of jars"),".jar");
        File f[] = dl.getFiles(".jar");
        for (int i=0; i < f.length; i++){
            System.out.println("signing:"+f[i]);
            sign(ks,pw,f[i],alias);
        }

    }

    public static void signOneJar(
            final String ks, final String pw, final String alias) {
        do {
            final File readFile = Futil.getReadFile("select jarfile");
            sign(
                    ks,
                    pw,
                    readFile,
                    alias);
            verify(readFile);
        } while (In.getBoolean("again?"));
    }

    public static void testPackSignAndVerify() {
        String className = "dhry.Main";

        String keystoreName = "keystore";
        String storepass = "password";
        String alias = "docjava";

        packSignAndVerify(
                className,
                keystoreName,
                storepass,
                alias);
    }

    public static void packSignAndVerify() {
        packSignAndVerify(
                gui.In.getString("enter class name"),
                futils.Futil.getReadFile("select keystore") + "",
                gui.In.getString("enter password"),
                gui.In.getString("enter alias"));

    }


    public static void packSignAndVerify(
            String className,
            String keystoreName,
            String storepass,
            String alias) {
        File jarFileName = new File(className + ".jar");
        try {
            PackUtils.pack(
                    className,
                    jarFileName);
        } catch (Exception e) {
            In.message(e);
            return;
        }
        sign(
                keystoreName,
                storepass,
                jarFileName,
                alias);

        verify(jarFileName);
    }

    public static void jarIt() {
        String a[] = {
            "-help"
        };
        sun.tools.jar.Main.main(a);
    }

    public static void sign(
            String keystoreName,
            String storepass,
            File jarFileName,
            String alias) {
        JarSigner js = new JarSigner();

        String a[] = {
            "-keystore",
            keystoreName,
            "-storepass",
            storepass,
            jarFileName.getAbsolutePath(),
            alias

        };
        js.run(a);
    }
 
    /**
     * This method causes the callers thread of execution to terminate
     * after the run!
     */
    public static void verify(File jarFileName) {
        JarSigner js = new JarSigner();
        System.out.println("verifying:" + jarFileName);
        String a[] = {
            "-verify",
            "-verbose",
            jarFileName.getAbsolutePath(),

        };
        js.run(a);
    }
}
