package security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;



/**
 * DocJava, Inc. User: lyon Date: Aug 3, 2004
 * Time: 10:07:24 AM
 */
public class CertUtils {


    public final static int LINE_LENGTH = 76;
    public final static String START = "BEGIN PKCS";
    public final static String END = "END PKCS";

    public static void main(String[] args)
            throws IOException {

        cleanThawtes();
        System.out.println("done!");

    }

    public static void cleanThawtes()
            throws IOException {
        BufferedReader r = new BufferedReader(
                futils.Futil.getFileReader(
                "select a Thawte file"));
        BufferedWriter w = new BufferedWriter(
                futils.WriterUtil.getFileWriter(
                "enter output file"));
        String line;
        line = scanUntilStart(r);
        w.write(line);
        w.newLine();
        int outIndex = 0;
        while ((line = r.readLine()) != null) {
            if (line.indexOf(END) != -1) {
                if (outIndex != 0)
                    w.newLine();
                w.write(line);
                break;
            }
            outIndex =
            packOutputTo76Chars(line,
                                w,
                                outIndex);
        }
        w.close();
        r.close();
    }

    private static int packOutputTo76Chars(
            String line,
            BufferedWriter w,
            int outIndex) throws IOException {
        int inIndex;
        inIndex = 0;
        while (inIndex < line.length()) {
            w.write(line.charAt(inIndex));
            outIndex++;
            if (outIndex == LINE_LENGTH) {
                w.newLine();
                outIndex = 0;
            }
            inIndex++;
        }
        return outIndex;
    }
    /**
     * Scan the buffered reader until the
     * start keyword is found.
     * @param r
     * @return
     * @throws IOException
     */
    private static String scanUntilStart(
            BufferedReader r) throws IOException {
        String line;
        while ((line = r.readLine()).indexOf(
                START) ==
               -1)
            ;
        return line;
    }

}
