package rdbms;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseWriter {
    private String url = null; // "jdbc:odbc:udb";
    private String uid = "";
    private String pw = "";
    private String driverName = null; //"sun.jdbc.odbc.JdbcOdbcDriver";
    private Connection c = null;

    public DatabaseWriter(
            String _url,
            String _uid,
            String _password,
            String _driverName) throws
            ClassNotFoundException {
        url = _url;
        uid = _uid;
        pw = _password;
        driverName = _driverName;
        Class.forName(driverName);
    }

    public static boolean batchExecute(
            String _url,
            String _uid,
            String _pw,
            String _driver,
            String sql[]) {
        try {
            DatabaseWriter dbw = new
                    DatabaseWriter(_url, _uid, _pw, _driver);
            dbw.execute(sql);
            return true;

        } catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public static boolean batchExecute(String sql[]) {
        try {
            DatabaseWriter dbw = new
                    DatabaseWriter(
                            "jdbc:odbc:udb", "", "", "sun.jdbc.odbc.JdbcOdbcDriver");
            dbw.execute(sql);

        } catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public void execute(String sql[])
            throws SQLException {
        c = DriverManager.getConnection(
                url, uid, pw);
        Statement s = c.createStatement();
        for (int i = 0; i < sql.length; i++)
            s.execute(sql[i]);
        s.close();
        c.close();

    }
}