package net.web;

import gui.dialogs.ProgressDialog;

import java.io.*;
import java.net.URL;
import java.util.Vector;

// SW409 4/6/05
// For homework, convert the main method so that it will populate
// the addressbook database in the JAddressBook package.
// Use address Records and an SAX parser to read the string output.
/*
Print a CD Label
Make the dimensions correct
Use the files in a given folder as your labels.
Directories start with a
Use the dir-lister to get the files. Or futils.Ls, as shown in class.
Arrange the files in alphabetical order
Include a date at the top of the list (i.e. 20050406)
126 mm w X
121 mm h
2.83 Pts/mm
357x342 Points (wxh)

*/
public class UrlUtils {
    public static void printVector(Vector v) {
        for (int i = 0; i < v.size(); i++) {
            System.out.println(v.elementAt(i));
        }
    }

    public static Vector lookForIPLawyersInUsa(int stateNumber, int pageNumber) {
        String s2 =
                "http://www.lawyers.com/find_a_lawyer/search/results.php?country=1&firmname=&firstname=&lastname=&searchtype=Q&termtype=1&personalaop=756&personalterm=&businessaop=&businessterm=&language=&pagenum=&city=&county=&" +
                "state=" +
                stateNumber +
                "&country=1&site=466&lm_id=&resultcount=126&sed=2487187&displaycount=126&sorttype=0" +
                "&pagenum=" +
                pageNumber;
        return getUrlVector(s2);
    }

    public static Vector lookForIPLawyersInCt(int pageNumber) {
        String s2 =
                "http://www.lawyers.com/find_a_lawyer/search/results.php?country=1&firmname=&firstname=&lastname=&searchtype=Q&termtype=1&personalaop=756&personalterm=&businessaop=&businessterm=&language=&pagenum=&city=&county=&" +
                "state=7&country=1&site=466&lm_id=&resultcount=126&sed=2487187&displaycount=126&sorttype=0" +
                "&pagenum=" +
                pageNumber;
        return getUrlVector(s2);
    }

    public static Vector lookForJobs(String keyword) {
        return
                getUrlVector
                //("http://jobsearch.monster.com/jobsearch.asp?q="+keyword);
                ("http://trading.etrade.com/cgi-bin/gx.cgi/Applogic+IPOCurrent");
    }

    // todo populate the address book with lawyers
    public static void main(String args[]) {
        //net.proxy.Proxy.setSoeProxy();
        //scanForLawyers();
        scanForLawyers();
    }

    private static void scanForLawyers() {
        for (int i = 1; i < 8; i++) {
            Vector v = lookForIPLawyersInCt(i);
            printLawyerFilter(v);
        }
    }

    public static void printLawyerFilter(Vector v) {
        for (int i = 0; i < v.size(); i++) {
            String s = (String) v.elementAt(i);
            if (s.indexOf("class=\'sponseredL\'") == -1) continue;
            if (s.indexOf("U.S.A") == -1) continue;
            int j = -1;
            j= s.indexOf("\'sponseredL\'>");
            System.out.println(s.substring(j));

        }
    }

    public static String getOneBigUrlString(String urlString) {
        Vector v = getUrlVector(urlString);
        return getOneBigString(v);
    }

    private static String getOneBigString(Vector v) {
        String s[] = new String[v.size()];
        v.copyInto(s);
        return getOneBigUrlString(s);
    }

    public static String getOneBigUrlString(String s[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; i++)
            sb.append(s[i] + '\n');
        return sb.toString();
    }

    public static String[] getUrlString(String urlString) {
        Vector v = getUrlVector(urlString);
        String s[] = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    /**
     * Read a url and put it into a file. This is very good when dealing
     * with large files.
     *
     * @param url input file (like data.jar)
     * @param f   locally created output file.
     */
    public static void getUrl(URL url, File f)
            throws IOException {

        FileOutputStream fos = new FileOutputStream(f);
        BufferedInputStream bis = new
                BufferedInputStream(url.openStream());
        int numberOfBytesRead = 0;
        int buffSize = 65536;
        byte b[] = new byte[buffSize];

        ProgressDialog pd = new ProgressDialog();
        pd.setSize(200, 80);
        pd.setMinimum(0);
        pd.setMaximum(bis.available());
        pd.setUnits(" bytes transferred");
        int amountTransferred = 0;
        pd.setVisible(true);
        while ((numberOfBytesRead = bis.read(b)) != -1) {
            fos.write(b, 0, numberOfBytesRead);
            pd.setAmountDone(amountTransferred);
            amountTransferred = amountTransferred + numberOfBytesRead;
        }
        bis.close();
        fos.close();
        pd.setVisible(false);
    }

    /**
     * Read in entire url at once, into an array of bytes, and return.
     *
     * @param url
     * @return
     */
    public static byte[] getUrlBytes(URL url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = null;
        byte b[] = new byte[4096];
        int numberOfBytesRead = 0;
        try {
            bis = new
                    BufferedInputStream(url.openStream());

            while ((numberOfBytesRead = bis.read(b)) != -1) {
                baos.write(b, 0, numberOfBytesRead);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (bis != null) bis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baos.toByteArray();
    }

    public static Vector getUrlVector(String _URLString) {
        Vector v = new Vector();
        BufferedReader br = null;
        try {
            URL url = new URL(_URLString);
            br = new BufferedReader(new
                    InputStreamReader(url.openStream()));

            String line;
            while (null != (line = br.readLine()))
                v.addElement(line);

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return v;
    }
}